#include "SummaryManager.h"
#include "NoiseOccupancySummaryWriter.h"
#include "SctData/NoiseOccupancyTestResult.h"
#include <TF1.h>

#include <iomanip>

namespace SctData {
    namespace TestSummary{
	using namespace std;

	void NoiseOccupancySummaryWriter::write(const TestResult& t, ostream& out) const throw(Sct::IoError, Sct::LogicError)
	{
	    t.getNScans();
	    const NoiseOccupancyTestResult& result  = dynamic_cast<const NoiseOccupancyTestResult&>(t);

	    out << "#\n%NO\n#"<<endl;
	    out << "#MAX    ICC     IDD" << endl;
	    out << std::setw(8) << 0 << std::setw(8) << 0 << endl;
	    out << "#TYP    ICC     IDD" << endl;
	    out << std::setw(8) << 0 << std::setw(8) << 0 << endl;
	    out << "#\n#      Offset    MeanOcc     RMSOcc      EstENC"<<endl;
	    for (unsigned ichip=0; ichip<nChipModule; ++ichip){
		const SctData::ChipNOResult& c = result.getChipResult(ichip);
		out << "#"<< getChipName(ichip) << endl;
		out << "   "
		    << std::setw(8) << c.offset      << "  "
		    << std::setw(8) << c.mean        << "  "
		    << std::setw(8) << c.rms         << "  "
		    << std::setw(8) << c.getNoise()  << endl;
	    }
	    out << "#\n";
	    SummaryWriter::write(t.getDefects(), out);
	}

	//------------------------------------------------------

	bool NoiseOccupancySummaryWriter::inMap = SummaryManager::instance().addWriter("SctData::NoiseOccupancyTestResult", shared_ptr<SummaryWriter>(new NoiseOccupancySummaryWriter()));
    }
}
