#ifndef SCTDATA_NPTGAIN_SUMMARYWRITER_H
#define SCTDATA_NPTGAIN_SUMMARYWRITER_H

#include "SummaryWriter.h"

namespace SctData {
    class NPtGainTestResult;
    namespace TestSummary{
	/**
	   Output the result of a NPtGainTest (i.e. 3-pt gain, and response curve).
	*/
	class NPtGainSummaryWriter : public SummaryWriter {
	public:
	    ///override
	    virtual void write(const TestResult& t, ostream& os) const throw(Sct::IoError, Sct::LogicError);
	private:
	    static bool inMap;
	    /**
	       Write out whether there is a defect on a particular chip.
	       @param ichip the chip index 0->11.
	       @param t the test result required.
	       @param out the output stream.
	     */
	    static void outputDefectOnChip(unsigned ichip, const NPtGainTestResult& t, ostream& out) throw();
	};
    }
}

#endif //#ifndef SCTDATA_NPTGAIN_SUMMARYWRITER_H
