#include "FullBypassSummaryWriter.h"
#include "SctData/FullBypassTestResult.h"
#include "SummaryManager.h"

namespace SctData {
    namespace TestSummary{
	void FullBypassSummaryWriter::write(const TestResult& t, std::ostream& out) const throw(Sct::IoError, Sct::LogicError)
	{
	    const FullBypassTestResult& result  = dynamic_cast<const FullBypassTestResult&>(t);
	    out << "#\n%FullBypassTest\n#\n";
	    out << "#NConfigs  " << result.getNConfig() << endl;
	    out << "#Vdd = " << result.getTestPointAt(0) << " -> " << result.getTestPointAt(result.getNScans()-1) << endl;
	    out << "#\n#Vmin\n#token\tr_tkn\ttoken\tr_tkn\n" << endl;
	    for (unsigned ichip=0; ichip<nChipModule; ichip+=2){
		out << "#" << getChipName(ichip) << "\t\t" << getChipName(ichip+1) << endl;
		out << result.getChipResult(ichip).vdd_direct << "\t" << result.getChipResult(ichip).vdd_bypass << "\t"
		    << result.getChipResult(ichip+1).vdd_direct << "\t" << result.getChipResult(ichip+1).vdd_bypass << endl;
	    }
	    
	    out << "#Comment" << endl;
	    for (unsigned ichip=0; ichip<nChipModule; ichip+=2){
		out << "#" << getChipName(ichip) << "\t\t" << getChipName(ichip+1) << endl;
		out << reason(result.getChipResult(ichip).status_direct) << "\t" 
		    << reason(result.getChipResult(ichip).status_bypass) << "\t"
		    << reason(result.getChipResult(ichip+1).status_direct) << "\t" 
		    << reason(result.getChipResult(ichip+1).status_bypass) << endl;
	    }

	    out << endl;

	    SummaryWriter::write(t.getDefects(), out);
	}

	string FullBypassSummaryWriter::reason(const short int status){
	    switch (status) {
	    case -3:
		return "\"Failing maximal tested Vdd\"";
	    case -2:
		return "\"Not Tested\"";
	    case -1:
		return "\"Minimal accessible\"";
	    case 0:
		return "\"Minimal functional\"";
	    case 1:
		return "\"Minimal tested\"";
	    default:
		return "\"Unknown!\"";
	    }
	}
	
	bool FullBypassSummaryWriter::inMap = SummaryManager::instance().addWriter("SctData::FullBypassTestResult", shared_ptr<SummaryWriter>(new FullBypassSummaryWriter()));
    }
}
