#include "../src/WorkerGroup.h"
#include "MyWorkerGroup.h"

using namespace SctService;
using namespace boost;
using namespace std;
using namespace Sct;

/*
   Simple test program exercises many aspects of the Worker/Observer pattern.
   Uses the concrete classes defined in "MyWorkerGroup.h"
   @author Alan Barr @date 16 July 2003
*/

int main(int argc, char** argv){
    setExceptionHandlers(argv[0]);
    
    MyWorkerGroup group;
    
    group.go(3);
    cout << "started worker-group, size = " << group.nWorkers() 
	 << " queue size = " << group.queueSize() << endl;

    for (int i=1; i<10; ++i){
	cout << " adding to queue: "<< i <<endl;
	    shared_ptr<MyClass> ptr( new MyClass(i) );
	group.push(ptr);
	cout << "Queue size=" << group.queueSize() << endl;
    }
    sleep (1);
    cout << endl << "\n\n****************  pausing workers:   NBUSY = " << group.busy() <<endl<<endl;
    
    group.setPaused(true);
    sleep(7);
    cout << endl << "\n\n****************  unpausing workers: NBUSY = " << group.busy() <<endl<<endl;
    group.setPaused(false);
    
    sleep (10);
    cout << endl<<"\n\n\n                                  NEW DATA \n\n"<< endl;
    for (int i=1; i<10; ++i){
	cout << " adding to queue: "<< i*4 <<endl;
	    shared_ptr<MyClass> ptr( new MyClass(i*4) );
	group.push(ptr);
	cout << "Queue size=" << group.queueSize() << endl;
    }
    sleep(1);
    cout << "\n\ncalling stop() on " << group.nWorkers() << " workers\n\n" << endl;
    group.stop();
    cout << "Queue size at end =" << group.queueSize() << endl;
    cout <<endl;
}
