#include "../src/WorkerGroup.h"
#include <boost/shared_ptr.hpp>

/*
  Simple implementation of the WorkerGroup template, showing how to sub-class
 */

using namespace SctService;
using namespace boost;
using namespace std;
using namespace Sct;

class MyClass{
public:
    MyClass() : value(0) {;}
    MyClass(int i) : value (i) {;}
    ~MyClass() {;}
    int value;
};


class MyWorkerGroup : public WorkerGroup<shared_ptr<MyClass> >{
public:
    MyWorkerGroup() : m_calls(0) , m_waits(0) {;}
    virtual ~MyWorkerGroup() {;}
    virtual void work(shared_ptr<MyClass>) throw();
    virtual void waitForData();
private:
    MyClass m_ob;
    int m_calls;
    int m_waits;
};

// Implementation:
void MyWorkerGroup::work(shared_ptr<MyClass> in) throw() {
    m_calls++;
    cout << "This is call number  " << m_calls << " to this worker. Working on object value " << in->value
	 << " Q = " << queueSize()<< endl;
    m_ob=*in;
    for (unsigned i=0; i<50000000; ++i){
	if (i%10000000==0) {
	    cout << "Internal object value = " << m_ob.value << ", i = "   << i << endl;
	}
    }
}

/// This isn't strictly necessary, but it lets you know what's going on:
void MyWorkerGroup::waitForData(){
    if (m_waits%400==0) cout <<"waiting..."; cout.flush();
    ++m_waits;
    wait(getSleepTime());
}
