#include "TrimRangeDisplayer.h"
#include "DisplayManager.h"
#include "DisplayInfo.h"

#include "SctData/TrimRangeTestResult.h"
#include "SctData/FitScanResult.h"
#include "Sct/SctParameters.h"

#include <TGraph.h>
#include <TCanvas.h>
#include <TH2.h>
#include <TF1.h>
#include <TLatex.h>

#include <iomanip>
#include <algorithm>

using namespace Sct;
using namespace SctData;
using namespace std;
using namespace boost;

namespace SctDataDisplay {
    
class TrimDisplayData : public DisplayData {
public:
    vector<shared_ptr<TCanvas> > canvas;
};   
    
bool TrimRangeDisplayer::inMap = DisplayManager::addToMap("SctData::TrimRangeTestResult", shared_ptr<Displayer>(new TrimRangeDisplayer()));    
    
shared_ptr<DisplayData> TrimRangeDisplayer::display(shared_ptr<const Sct::Serializable> serial, const DisplayInfo& info, std::ostream& os) {    
    shared_ptr<TrimDisplayData> data (new TrimDisplayData());
    shared_ptr<const TrimRangeTestResult> result = dynamic_pointer_cast<const TrimRangeTestResult>(serial);

    shared_ptr<TCanvas> c = createCanvas(result->getModuleName() + "_TrimData", result->getModuleName() + " Trim Range Fits");
    data->canvas.push_back(c);
    c->Divide(4, 3);
    for (unsigned int ichip = 0; ichip < nChipModule; ++ichip) {
        c->cd(ichip + 1);
	char name[100]; sprintf(name,"Chip_%d",ichip);
	TH2D* hist = new TH2D(name,name,10,0,300,10,0,16);
	hist->Draw();

	int range=result->chipTrim[ichip]->range;
	char txt[10];
	sprintf(txt,"R%d",range);
	TLatex* lab=new TLatex();
	lab->SetTextSize(0.1);
	lab->DrawLatex(0,0,txt);

	for (unsigned ichannel=0; ichannel<nChannelChip; ++ichannel){
	    if (result->chipTrimData[ichip]!=0){
		Stat<TrimRangeTestResult::TrimData> trim = result->chipTrimData[ichip]->channelData.getAt(ichannel);
		TGraph* g = new TGraph();
		g->SetMarkerColor(ichannel);
		g->SetMarkerStyle(21);
		g->SetMarkerSize(0.5);
		g->Set(trim.value.graph.size());
		for (unsigned ipt=0; ipt<trim.value.graph.size(); ++ipt){
		    g->SetPoint(ipt,trim.value.graph[ipt].first, trim.value.graph[ipt].second);
		}
		g->SetLineColor(ichannel);
		g->SetLineWidth(1);
		if (g->GetN()!=0 ){
		    g->Draw("LP");
		}
	    }
	}
    }
  
    shared_ptr<TCanvas> c2 = createCanvas(result->getModuleName() + "_Trims", result->getModuleName() + " Trims");
    data->canvas.push_back(c2);
    c2->Divide(1, 4);
    for (unsigned int ilink = 0; ilink < nLinkModule; ++ilink) {
	TGraph* g1 = new TGraph();
	TGraph* g2 = new TGraph();
	g1->SetMarkerColor(2);
	g1->SetMarkerStyle(21);
	g1->SetMarkerSize(1);
	g2->SetMarkerColor(2);
	g2->SetMarkerStyle(21);
	g2->SetMarkerSize(1);

	// find number of trimmed channels:
	int npoints=0;
	for (unsigned ichip=ilink*nChipLink; ichip<(ilink+1)*nChipLink; ++ichip){
	    if (result->chipTrim[ichip]==0){
		cerr << " no trim at chip "<< ichip << endl; continue;
	    }
	    npoints += result->chipTrim[ichip]->channelTrim.n();
	}
	
	g1->Set(npoints);
	g2->Set(npoints);

	int ipoint=0;
	for (unsigned ichannel=ilink*nChannelLink; ichannel<(ilink+1)*nChannelLink; ++ichannel){

	    if (result->chipTrim[ichannel/128]==0){
		continue;
	    }

	    Stat<TrimRangeTestResult::Trim> trim = result->chipTrim[ichannel/128]
		->channelTrim.getAt(ichannel%128);

	    if (trim.valid){
		g1->SetPoint(ipoint,ichannel%nChannelLink,trim.value.trim);
		g2->SetPoint(ipoint,ichannel%nChannelLink,trim.value.vthr);
		++ipoint;
	    }
	}
	
	char name[100]; sprintf(name,"Link_%d_t",ilink);
	TH2D* hist1 = new TH2D(name,name,768,-0.5,767.5,16,-0.5,15.5);
	sprintf(name,"Link_%d_v",ilink);
	TH2D* hist2 = new TH2D(name,name,768,-0.5,767.5,3,0.,300.);
	c2->cd(ilink*2 + 1);
	hist1->Draw();
	g1->Draw("P");
	c2->cd(ilink*2 + 2);
	hist2->Draw("");
	g2->Draw("P");
	for (unsigned ichip=ilink*nChipLink; ichip<(ilink+1)*nChipLink; ++ichip){
	    int range=result->chipTrim[ichip]->range;
	    char txt[10];
	    sprintf(txt,"R%d",range);
	    TLatex* lab=new TLatex();
	    lab->SetTextSize(0.1);
	    lab->DrawLatex(nChannelChip*(ichip%nChipLink)+nChannelChip/2,10,txt);
	}

    }    
    
    //Now print out defects:
    os << endl << "Defects: " << endl;
    printDefectList(result->getDefects(), os);

    return data;
}
}
