#ifndef SCTDATADISPLAY_TESTDISPLAYER_H
#define SCTDATADISPLAY_TESTDISPLAYER_H

#include "Displayer.h"

#include <vector>
#include <boost/shared_ptr.hpp>

using std::vector;
using boost::shared_ptr;

class TCanvas;

namespace SctData {
    class TestResult;
}

namespace SctDataDisplay {

class TestDisplayData : public DisplayData {
public:
    vector<shared_ptr<TCanvas> > canvas;
    vector<shared_ptr<DisplayData> > otherData;
	
};


/**
  Displays stuff common to all tests
  @author Matthew Palmer
  */
class TestDisplayer : public virtual GenericDisplayer {
public:
  TestDisplayer() {}
    /**
      Displays some standard stuff common to all TestResults then calls displayTestResult
      */
    shared_ptr<DisplayData> display(shared_ptr<const Sct::Serializable> data, const DisplayInfo& info, std::ostream& os);

    virtual bool canDisplay(const Sct::Serializable& ob);
    
protected:
    /**
      Should be overriden by subclasses - the default is to call displayAllRaws
      */
    virtual void displayTestResult(const SctData::TestResult& result, TestDisplayData& data, const DisplayInfo& info, std::ostream& os);
    
    /**
      Displays all the raw data objects associated with the TestResult
      */
    void displayAllRaws(const SctData::TestResult& result, TestDisplayData& data, const DisplayInfo& info, std::ostream& os);
    
private:
    void printSummaryString(const SctData::TestResult& result, std::ostream& os);
    static bool inList;	///< true if in the list of GenericDisplayers
};
}

#endif //SCTDATADISPLAY_NOISEOCCUPANCYDISPLAYER_H
