#include "TestDisplayer.h"
#include "DisplayManager.h"

#include "SctData/TestResult.h"
#include "Sct/IS/IOManagerIS.h"
#include "Sct/SctNames.h"
#include "Sct/LogicErrors.h"
#include "SummaryWriter/SummaryManager.h"
#include "Sct/Archive/IOManagerArchiveFile.h"
#include "Sct/Archive/IONameArchiveFile.h"

#include <TCanvas.h>

using namespace Sct;
using namespace Sct::IS;
using namespace SctData;
using namespace boost;

namespace SctDataDisplay {

bool TestDisplayer::inList = DisplayManager::addGeneric(shared_ptr<GenericDisplayer>(new TestDisplayer));

shared_ptr<DisplayData> TestDisplayer::display(shared_ptr<const Sct::Serializable> ob, const DisplayInfo& info, std::ostream& os) {
    shared_ptr<TestDisplayData> data (new TestDisplayData);
    shared_ptr<const TestResult> tr = dynamic_pointer_cast<const TestResult>(ob);
    if (!tr) throw InvalidArgumentError("TestDisplayer::display called but argument is not a TestResult", __FILE__, __LINE__);
 
    printSummaryString(*tr, os);
    displayTestResult(*tr, *data, info, os);
    
    return data;
}
    
void TestDisplayer::displayTestResult(const TestResult& result, TestDisplayData& data, const DisplayInfo& info, std::ostream& os) {
    displayAllRaws(result, data, info, os);
}



bool TestDisplayer::canDisplay(const Sct::Serializable& ob) {
    const TestResult* tr = dynamic_cast<const TestResult*>(&ob);
    if (tr != 0) return true;
    return false;
}



void TestDisplayer::displayAllRaws(const TestResult& result, TestDisplayData& data, const DisplayInfo& info, std::ostream& os) {
    unsigned int runNumber = result.getRunNumber();
    string moduleName = result.getModuleName();
    for (unsigned int i=0; i<result.getNScans(); ++i) {
	unsigned int scanNumber = result.getScanNumberAt(i);
	
	shared_ptr<Serializable> ob;
	try {
	  string isName = SctNames::getEventDataName() + ".SctData::RawScanResult." + ResultHeader::getUniqueID(runNumber, scanNumber, moduleName);
	  ob = IOManagerIS::instance().read(isName);
	}catch (IoException&e){
	}
	if (!ob.get()){
	  Sct::Archive::IONameArchiveFile namearch(result.getUniqueID(), result.getClassName());
	  ob=Sct::Archive::IOManagerArchiveFile::instance().read(namearch.getIOName());
	}
	data.otherData.push_back(DisplayManager::display(ob, info, os));
    }
}

void TestDisplayer::printSummaryString(const TestResult& result, std::ostream& os) {
  if (DisplayManager::batchMode()){
    SctData::TestSummary::SummaryManager::instance().write(result, os);
  }
}
    
}
