#include "StrobeDelayDisplayer.h"
#include "DisplayManager.h"
#include "DisplayInfo.h"

#include "SctData/StrobeDelayTestResult.h"
#include "SctData/FitScanResult.h"
#include "SctData/ConfigurationVariable.h"

#include <TCanvas.h>
#include <string>
#include <iomanip>
#include <boost/scoped_ptr.hpp>

using namespace Sct;
using namespace SctData;
using namespace std;
using namespace boost;

namespace SctDataDisplay {

bool StrobeDelayDisplayer::inMap = DisplayManager::addToMap("SctData::StrobeDelayTestResult", shared_ptr<Displayer>(new StrobeDelayDisplayer()));    
    
shared_ptr<DisplayData> StrobeDelayDisplayer::display(shared_ptr<const Sct::Serializable> data, const DisplayInfo& info, std::ostream& os) {
    shared_ptr<const StrobeDelayTestResult> result = dynamic_pointer_cast<const StrobeDelayTestResult>(data);
    
    os << "Module: " << result->getModuleName() << endl;

    //Now print out defects:
    os << "Defects: " << endl;
    printDefectList(result->getDefects(), os);
    
    for (unsigned int ichip=0; ichip<result->getNOptima(); ++ichip) {
	os << "StrobeDelay for chip: " << ichip << "  " << setprecision(2) << (int) (result->getOptimum(ichip)+0.5) << endl;
    }
    
    return shared_ptr<DisplayData>();
}
}
