#ifndef SCTDATADISPLAY_NPTGAINDISPLAYER_H
#define SCTDATADISPLAY_NPTGAINDISPLAYER_H

#include "Displayer.h"

class TGraph;

namespace SctData {
    class NPtGainTestResultData;
}

namespace SctDataDisplay {

    class NPtGainDisplayData;
    
/**
  Displays NPtGain Test Results
  @author Matthew Palmer
  */
class NPtGainDisplayer : public Displayer {
public:
  NPtGainDisplayer(){}

    shared_ptr<DisplayData> display(shared_ptr<const Sct::Serializable> data, const DisplayInfo& info, std::ostream& os);
    
private:
    static bool inMap;
    
    /**
      Displays chip fits
      */
    void displayChips(NPtGainDisplayData& data, const DisplayInfo& info, std::ostream& os);
    
    /**
      Displays channel fits
      */
    void displayChannels(NPtGainDisplayData& data, const DisplayInfo& info, std::ostream& os);
    
    /**
      Displays a single NPtGainTestResultData
      */
    void displayData(NPtGainDisplayData& data, const SctData::NPtGainTestResultData& testData);

    /**
        Plots some data
    */
    void plotData(string name, double min, double max, NPtGainDisplayData& data, TGraph& graph);
};
}

#endif //SCTDATADISPLAY_NPTGAINDISPLAYER_H
