#include "Displayer.h"
#include "SctData/DefectList.h"
#include "DisplayManager.h"
#include <cmath>
#include <TCanvas.h>
#include <TROOT.h>
#include <iostream>
#include <iomanip>
#include <boost/lexical_cast.hpp>

using namespace std;
using namespace boost;
using namespace SctData;

namespace SctDataDisplay {

shared_ptr<TCanvas> Displayer::createCanvas(string name, string title) {
    unsigned int i=0;
    string rname;
    TCanvas* old = 0;
    do {
        ++i;
        rname = name + lexical_cast<string>(i);
	old = dynamic_cast<TCanvas*>(gROOT->GetListOfCanvases()->FindObject(rname.c_str()));
    } while(old != 0);
    shared_ptr<TCanvas> canvas = shared_ptr<TCanvas>(new TCanvas(rname.c_str(), title.c_str()));
    if ( DisplayManager::batchMode() ) canvas->SetBatch();
    return canvas;
}

void Displayer::divideCanvas(unsigned int n, TCanvas& canvas) {
    unsigned int x = (unsigned int)(ceil(sqrt((double)n)));
    unsigned int y = (unsigned int)(ceil((double)n/x));
    canvas.Divide(x, y);
}


void Displayer::printDefectList(const DefectList& list, std::ostream& os) {
  const DefectList::DefectCollection& defects = list.getAllDefects();
    
  for (DefectList::DefectCollection::const_iterator i=defects.begin(); i!=defects.end(); ++i) {
    os << setfill(' ') << setw(20) << i->getPrototype().getName()
       <<  "\tStart channel: " << i->getModuleElement().getFirst()
       << "\t# of channels: " << i->getModuleElement().getNChannels()
       << "\t" << i->getPrototype().getDescription() << std::endl;
  }
  os << "[ total number of defects = " <<  defects.size() << " ]" << std::endl;
  os << std::endl;
}

}
