import ipc.*;

public class test_client {
    public static void main(String args[]) {
	//System.setProperty("ipc.ref.file", "/work/daq-1/installed/com/ipc_root.ref");
	Partition p= new Partition("SCT");

        org.omg.CORBA.Object obj = p.lookup("SCTSctApiServer", "Test_Server"); 
        if (obj == null) System.out.println("Object SCTSctApiServer not found in server Test_Server");
        Sct_SctApi.SctApi h = Sct_SctApi.SctApiHelper.narrow(obj);

	if (h==null) {
	    System.err.println("Error (check SctApi running) obj was " + obj);
	    return;
	}
        System.out.println("Found SctApi server");

        h.status();

        Sct_SctApi.Scan scan = null;

        try {
          obj = h.createScan(); 
          if (obj == null) System.out.println("Couldn't get default Scan");
          scan = Sct_SctApi.ScanHelper.narrow(obj);
        } catch(org.omg.CORBA.BAD_PARAM e) {
          System.out.println(e);
        }

        if(scan == null) {
            System.err.println("Error getting scan, obj was " + obj);
            return;
        } else {
            System.err.println("Got a scan " + scan);
        }

        scan.print();

        scan.configure((short)9, 0.0, 128.0, 1.0);
        System.out.println("Configured1");

        scan.configure2((short)9, 0.0, 128.0, 1.0);
        System.out.println("Configured2");

        Sct_SctApi.Trigger trig = scan.getTrigger1();
        System.out.println("gotTrigger");
        trig.print();
        System.out.println("print trigger");
        trig = scan.getTrigger2();
        System.out.println("gotTrigger2");
        trig.print();
        System.out.println("print trigger");

        scan.setScanVariable1((short)7);
        System.out.println("Scan var 1");
        scan.setScanVariable2((short)7);
        System.out.println("Scan var 2");

        scan.print();

        double points[] = scan.getScanPoints1();
        System.out.println("Scan points 1");
        points = scan.getScanPoints2();
        System.out.println("Scan points 2");

        scan.setNTrigs(1000);

//          h.initialiseAll(2);
//          h.shutdownAll();

        h.destroy();
    }
}
