#include <ipc/object.h>

#include "Sct_SctApi.hh"

int main(int argv, char** argc) {
  Sct_SctApiStatus status;	
  IPCPartition p("SCT");
  IPCObjectVar<Sct_SctApi_T_SctApi> tapi = 
    p.lookup("Test_Server", "SCTSctApiServer", Sct_SctApi_T_SctApi::ILUClassRecord);
  if (tapi ==0 ) {
    std::cout << "Error getting SctApi" << std::endl;
    return -1;
  }
  status.returnCode = 0;

  std::cout << "Successfully got the Api server reference?\n";

  tapi->status(&status);

  std::cout << "Get default Scan\n";

  IPCObjectVar<Sct_SctApi_T_Scan> nmask = 
    tapi->createScan(&status);

  if (nmask == 0) {
    std::cout << "Error getting scan\n";
    return -1;
  } else {
    std::cout << "*******  Try printing scan before modification\n";
    nmask->print(&status);
  }

  std::cout << "Set up for nmask...\n";

  nmask->setNTrigs(&status, 1000);
//   nmask->setOption(&status, Sct_SctApi_T_Scan_ScanOptions_distSlave, 1);
  nmask->configure(&status, 9, 0, 128, 1);
  nmask->getTrigger1(&status)->singleL1A(&status);

  std::cout << "*******  Try printing scan after modification\n";
  nmask->print(&status);

  tapi->initialiseAll(&status, 1);

  tapi->modifyABCDVar(&status, 14, 1.0);     // Send mask bit

  std::cout << "Try doing scan\n";
  tapi->doScan(&status, nmask);
  std::cout << "Done!\n";

  tapi->shutdownAll(&status);

  ipcStatus statusIPC;

  nmask->destroy(&statusIPC);
}
