#ifndef SCTAPI_UTILITY_H
#define SCTAPI_UTILITY_H

#include <iostream>
#include <boost/shared_array.hpp>

#include "SctApiFwd.h"

#include "processor.h"

namespace SctApi {
  namespace Utility {
    inline void getpcrc(UINT32 mid, unsigned int &partition, unsigned int &crate, unsigned int &rod, unsigned &channel) 
    {
      partition = (mid & 0xff000000) >> 24;
      crate = (mid & 0xff0000) >> 16;
      rod = (mid & 0xff00) >> 8;
      channel = (mid & 0xff) >> 0;
    }

    inline UINT32 packpcrc(unsigned int &partition, unsigned int &crate, unsigned int &rod, unsigned &channel)
    {
      UINT32 mid = 0;
      mid |= (partition & 0xff) << 24;
      mid |= (crate & 0xff) << 16;
      mid |= (rod & 0xff) << 8;
      mid |= (channel & 0xff) << 0;
      return mid;
    }

    inline void printHex(UINT32 num, int width) {
      std::cout << "0x";
      char saveFill = std::cout.fill('0');
      std::cout.width(width);
      std::cout.setf(std::ios::right);
      std::cout << std::hex << num << std::dec;
      std::cout.fill(saveFill);
    }

    void printMemoryBlock(std::ostream &os, unsigned long *mem, unsigned long words, int wordsPerLine, int level = 0);

    int translateBank(BankType bank);

    class MemoryBlock {
      unsigned int words;
      boost::shared_array<unsigned long> buffer;

    public:
      MemoryBlock() : words(0), buffer(0) {}
      MemoryBlock(unsigned int size, unsigned long *pointer) : words(size), buffer(pointer) {}

      operator bool() { return buffer; }

      unsigned int size() { return words; } 

      unsigned long operator[] (unsigned int i) {return buffer[i]; }

      unsigned long *address() {return buffer.get(); }
    };
  }
}

#endif
