#define USELIBRARY

#include <fstream>
#include <cstdlib>

#include "../primUtils.h"

using namespace std;

struct { 
  int reply;
} globalConf;

static void usage();
static void parseArgs(int argc, char **argv);

int main(int argc, char **argv) {
  globalConf.reply = 0;
  parseArgs(argc, argv);

  string fileName = argv[argc-1];

  ifstream fin(fileName.c_str(), ios::binary);

  cout << "Reading " << fileName << endl;

  if(fin.is_open()) {
    fin.seekg(0, std::ios::end);
    int fileSize = fin.tellg();
    fin.seekg(0, std::ios::beg);

    cout << "Filesize " << fileSize << endl;

    unsigned long *buffer = new unsigned long[fileSize / 4];
   
    fin.read((char*)&buffer[0], fileSize);

    SctApi::printOutList(buffer, fileSize/4, !globalConf.reply, 0, cout, false, false);
  } else {
    cout << "Couldn't open file " << fileName << "\n";
  }
}

void parseArgs(int argc, char **argv) {
  if(argc < 2) {
    usage();
    exit(1);
  } else {
    for(int i=1; i<argc-1; i++) {
      if(argv[i][0] == '-') {
        switch(argv[i][1]) {
        case 'r':
          globalConf.reply = 1;
          break;
        case 'h':
          usage();
          exit(1);
          break;
        }
      }
    }
  }
}

void usage() {
  cout << "usage: PrimList [opts] Filename\n";
  cout << "   where filename is a file containing a raw primitive list\n";
  cout << "\t-r This is a reply list\n";
}
