#define USELIBRARY

#include <iostream>

#include "../TApi.h"

int main() {

  std::set_terminate(__gnu_cxx::__verbose_terminate_handler);


  TScanDef nmask;

  nmask.trigsPerBurst = 10;

  nmask.configure(9, 0, 128, 1);

  nmask.trigSequence.singleL1A();

  nmask.print();

  nmask.debug = 1;

  // Start TApi
  TApi tapi;

  tapi.initialiseAll(0);

  tapi.setDebugOption("save_histogram");

  tapi.sendABCDModules(0);

  tapi.modifyABCDVar(11, 1.0);
  tapi.modifyABCDVar(13, 0.0);
  tapi.modifyABCDVar(14, 1.0);     // Send mask bit
  tapi.doScan(nmask);

  tapi.awaitScan();

  std::cout << "NMASK: Scan complete\n";
}
