#define USELIBRARY

#include <iostream>

#include "../TApi.h"

using namespace std;

struct { 
  int repetitions;
  unsigned int length;
  unsigned long *echoData;
  int multiRod;
} globalConf;

void usage();
void parseArgs(int argc, char **argv);
void buildData();
bool checkResponse(bool verbose, unsigned long *body, unsigned long length);

int main (int argc, char **argv) {
  TApi tapi;

  bool cont = true;

  int count = 0;

  globalConf.repetitions = 1;
  globalConf.length = 2;
  globalConf.multiRod = 0;

  parseArgs(argc, argv);

  buildData();

  tapi.initialiseAll(0);

  std::list<SctApi::RodLabel> rodList;
  if(globalConf.multiRod) {
    rodList = tapi.listRods();
    cout << "Send echo to All RODs\n";
  }

  try {
    for(int rep=0; rep<globalConf.repetitions && cont == true; rep++) {
      try {
        if(cont) {
          if(globalConf.multiRod) {
            tapi.echoAll(globalConf.length, globalConf.echoData);
          } else {
            tapi.echo(0, 0, 0, globalConf.length, globalConf.echoData);
          }
        }
      } catch(...) {
        cout << "Exception sending echo primitive\n";
        cont = false;
      }

      try {
        if(cont) { 
          if(globalConf.multiRod) {
//             cerr << "Starting await response chain\n";
            for(list<SctApi::RodLabel>::const_iterator ri = rodList.begin(); ri != rodList.end(); ri++) {
//               cerr << "Going to await response on " 
//                    << ri->partition << " " << ri->crate << " " << ri->rod << "\n";
              tapi.awaitResponse(ri->partition, ri->crate, ri->rod);
//               cerr << "Done await response on " 
//                    << ri->partition << " " << ri->crate << " " << ri->rod << "\n";
            }
//             cerr << "Done await response\n";
          } else {
            //         cerr << "Going to await response\n";
            tapi.awaitResponse(0, 0, 0);
            //         cerr << "Done await response\n";
          }
        }
      } catch(...) {
        cout << "Exception awaiting echo response\n";
        cont = false;
      }

      if(globalConf.multiRod) {
//         cerr << "Starting check response chain\n";
        for(list<SctApi::RodLabel>::const_iterator ri = rodList.begin(); ri != rodList.end(); ri++) {
//           cerr << "Going to check response on " 
//                << ri->partition << " " << ri->crate << " " << ri->rod << "\n";
          unsigned long length;
          unsigned long *body = tapi.getResponse(ri->partition, ri->crate, ri->rod, &length);

          if(body) {
            if(!checkResponse(rep == 0, body, length)) {
              cout << "Check failed repetition " << rep << "\n";
            } else {
              count ++;
            }
          } else {
            cout << "Response was null\n";
            cont = false;
          }

//           cerr << "Done check response on " 
//                << ri->partition << " " << ri->crate << " " << ri->rod << "\n";
        }
//         cerr << "Done check response chain\n";
      } else {
        unsigned long length;
        unsigned long *body = tapi.getResponse(0, 0, 0, &length);

        if(body) {
          if(!checkResponse(rep == 0, body, length)) 
            cout << "Check failed repetition " << rep << "\n";
        } else {
          cout << "Response was null\n";
          cont = false;
        }
      }
    }
    cout << "Complete\n";
  } catch(...) { // SctPixelRod::BaseException &b) {
    cout << "Got exception!" << endl;
  }

  if(globalConf.repetitions > 1) {
    cout << "Sent " << count << " successful primitives\n";
  }

  delete [] globalConf.echoData;

  tapi.shutdownAll();
  //  delete tapi;
}

bool checkResponse(bool verbose, unsigned long *outBody, unsigned long outLength) {
//   unsigned long outLength;

//   unsigned long *outBody = tapi.getResponse(0, 0, 0, &outLength);
//   if(outBody) {
    if(verbose) {
      // Print results (User processing of outList)
      unsigned long outIndex = (unsigned long)(outBody[1]);
      unsigned long outNumPrims = outBody[2];
      unsigned long outPrimVersion = outBody[3];
      cerr << "outLength = " << outLength << ", outIndex = " << outIndex
           << ", outNumPrims = " << outNumPrims << ", outPrimVersion = "
           << outPrimVersion << '\n';
      int outPtr = 4;
      for (unsigned int j=0; j<outNumPrims; j++) {
        unsigned long primLength = outBody[outPtr++];
        unsigned long primIndex = outBody[outPtr++];
        unsigned long primId = outBody[outPtr++];
        unsigned long primVersion = outBody[outPtr++];
        cout << "primLength = " << primLength << ", primIndex = " << primIndex 
             << ", primId = " << primId << ", primVersion = " << primVersion << '\n';
        cout << "ECHO data: \n";
        hex(cout);
        for (unsigned int i=0; i<primLength-4; i++) {
          cout.width(8);
          cout << outBody[i+outPtr] <<" ";
          if (0 == (i+1)%8) cout << endl; 
        }
        if (0 != (primLength-4)%8) cout << endl;
        dec(cout);
      }
    }

    bool correct = true;
    for(unsigned int i=0; i<globalConf.length; i++) {
      if(outBody[i+8] != globalConf.echoData[i]) {
        correct = false;
        cout << "Check failed at word " << i << "\n";
        break;
      }
    }

    if(correct) cerr << ".";
    //         cout << "EchoTest completed successfully?\n";

    delete [] outBody;

    return correct;
}

void buildData() {
  // Create and Send a simple ECHO primitive
  globalConf.echoData = new unsigned long[globalConf.length];

  if(globalConf.length < 3) {
    if(globalConf.length > 0) globalConf.echoData[0] = 0xDEADF00D;
    if(globalConf.length > 1) globalConf.echoData[1] = 0x0;
  } else {
    for (unsigned int i=0; i<globalConf.length; i++) {
      globalConf.echoData[i] = 0xBEAD0000 + i;
    }
  }
}

void parseArgs(int argc, char **argv) {
  if(argc > 1) {
    for(int i=1; i<argc; i++) {
      if(argv[i][0] == '-') {
        switch(argv[i][1]) {
        case 'r':
          globalConf.repetitions = atoi(&argv[i][2]);
          break;
        case 'l':
          globalConf.length = atoi(&argv[i][2]);
          break;
        case 'm':
          globalConf.multiRod = 1;
          break;
        case 'h':
          usage();
          exit(1);
          break;
        }
      }
    }
  }
}

void usage() {
  cout << "EchoTest [opts]\n";
  cout << "\t-r# Repeat # times\n";
  cout << "\t-l# Send echo with length #\n";
  cout << "\t-m  Use all RODs\n";
  cout << "\t-h  Show this help\n";
}

