#define USELIBRARY

#include <iostream>

#include "../TApi.h"

using namespace std;

int main (int argc, char **argv) {
  TApi tapi;

  tapi.initialiseAll(0);

  bool cont = true;

  int repetitions = 1;
  int length = 2;

  if(argc > 1) {
    for(int i=1; i<argc; i++) {
      if(argv[i][0] == '-') {
        switch(argv[i][1]) {
        case 'r':
          repetitions = atoi(&argv[i][2]);
          break;
        case 'l':
          length = atoi(&argv[i][2]);
          break;
        }
      }
    }
  }

  // Create and Send a simple ECHO primitive
  unsigned long *echoData; // [2] = {0xDEADF00D,0};

  echoData = new unsigned long[length];

  if(length < 3) {
    if(length > 0) echoData[0] = 0xDEADF00D;
    if(length > 1) echoData[1] = 0x0;
  } else {
    for (int i=0; i<length; i++) {
      echoData[i] = 0xBEAD0000 + i;
    }
  }

  tapi.createDebugPrimList();

  const int ECHO = 0;
  const int R_ECHO = 100;

  tapi.addDebugPrimList(4 + length, 1, ECHO, R_ECHO, echoData);

  // Send echo primitive

  cout << "ECHO3 sending standard primlist\n";

  cout << " Sending slave echo primlists\n";

  try {
    for(int rep = 0; rep<repetitions && cont; rep++) {
      // Send echo primitive via slave DSP

      try {
        /// Should check slave 0 is running first
        if(cont)
          tapi.sendDebugSlavePrimList(0, 0, 0, 0, 1, 1);
      } catch(...) {
        cout << "Exception sending echo primitive\n";
        cont = false;
      }

      try {
        if(cont) { 
//           cerr << "Going to await response\n";
          tapi.awaitResponse(0, 0, 0);
//           cerr << "Done await response\n";
        }
      } catch(...) {
        cout << "Exception awaiting echo response\n";
        cont = false;
      }

      unsigned long outLength;

      unsigned long *outBody = tapi.getResponse(0, 0, 0, &outLength);
      // Decode the reponse
      if(outBody) {
        if(rep == 0) {
          // Print raw hex data
          hex(cout);
          for (unsigned int i=0; i<outLength; i++) {
            cout.width(8);
            cout << outBody[i] << " ";
            if (0 == (i+1)%8) cout << endl; 
          }
          if (0 != (outLength)%8) cout << endl;
          dec(cout);

          // User processing slightly more difficult as have to
          // read the outlist returned by the slave
        }

        bool correct = true;
        for(int i=0; i<length; i++) {
          if(outBody[i+16] != echoData[i]) {
            correct = false;

            cout << "Check failed! " << rep << " + " << i << "\n";
            cout << hex << " 0x" << outBody[i+16] << " != 0x" << echoData[i] << dec << "\n";

            break;
          }
        }

        if(correct) cerr << ".";

        delete [] outBody;
      } else {
        cout << "Response was null\n";
      }
    }
    cout << "Complete\n";
  } catch(...) { // SctPixelRod::BaseException &b) {
    cout << "Got exception!" << endl;
  }

  try {
    cerr << "Check text buffers...\n";
    tapi.awaitResponse(0, 0, 0, 1);
    cerr << "Done await response\n";
  } catch(...) {
    cout << "Exception checking text buffers?\n";
  }

  tapi.shutdownAll();
}

