#define USELIBRARY

#include <iostream>

#include "../TApi.h"

using namespace std;

int main () {
  TApi tapi;

  tapi.initialiseAll(0);

  bool cont = true;

  // Create and Send a simple ECHO primitive
  unsigned long echoData[2] = {0xDEADF00D,0};

  tapi.createDebugPrimList();

  const int ECHO = 0;
  const int R_ECHO = 100;

  tapi.addDebugPrimList(4 + 2, 1, ECHO, R_ECHO, echoData);

  // Send echo primitive

  cout << "ECHO3 sending standard primlist\n";

  try {
    if(cont)
      tapi.sendDebugPrimList(0, 0, 0);
  } catch(...) {
    cout << "Exception sending echo primitive\n";
    cont = false;
  }

  try {
    if(cont) { 
      cerr << "Waiting for response from master\n";
      tapi.awaitResponse(0, 0, 0);
      cerr << "Done await response\n";
    }
  } catch(...) {
    cout << "Exception awaiting echo response\n";
    cont = false;
  }

  unsigned long outLength;

  unsigned long *outBody = tapi.getResponse(0, 0, 0, &outLength);

  // Send echo primitive via slave DSP

  cout << "ECHO3 sending slave primlist\n";

  try {
    /// Should check slave 0 is running first
    if(cont)
      tapi.sendDebugSlavePrimList(0, 0, 0, 0, 1, 1);
  } catch(...) {
    cout << "Exception sending echo primitive\n";
    cont = false;
  }

  try {
    if(cont) { 
      cerr << "Going to await response\n";
      tapi.awaitResponse(0, 0, 0);
      cerr << "Done await response\n";
    }
  } catch(...) {
    cout << "Exception awaiting echo response\n";
    cont = false;
  }

  delete [] outBody;

  outBody = tapi.getResponse(0, 0, 0, &outLength);

  // Decode the reponse
  if(outBody) {
    // Print raw hex data
    hex(cout);
    for (unsigned int i=0; i<outLength; i++) {
      cout.width(8);
      cout << outBody[i] << " ";
      if (0 == (i+1)%8) cout << endl; 
    }
    if (0 != (outLength)%8) cout << endl;
    dec(cout);

    // User processing slightly more difficult as have to
    // read the outlist returned by the slave

    delete [] outBody;
  } else {
    cout << "Response was null\n";
  }

  try {
    if(cont) { 
      cerr << "Check text buffers...\n";
      tapi.awaitResponse(0, 0, 0, 1);
      cerr << "Done await response\n";
    }
  } catch(...) {
    cout << "Exception awaiting echo response\n";
    cont = false;
  }

  tapi.shutdownAll();
}

