#define USELIBRARY

#include <iostream>

#include "../TApi.h"

void readResponse(TApi &tapi);

using namespace std;

//  TApi *tapi;

int main () {
  TApi tapi;

  tapi.initialiseAll(0);

  // Create and Send ECHO primitives

  unsigned long echo1Data[2] = {0xABCDF00D,0};
  tapi.echo(0, 0, 0, 2, echo1Data);
  readResponse(tapi);

  unsigned long echo2Data[3] = {0xFFFFFFFF, 0xA0A0A0A0, 0x55555555};
  tapi.echo(0, 0, 0, 3, echo2Data);
  readResponse(tapi);

  unsigned long echo3Data[4] = {0xABCDEF77, 0x01234567, 0x89ABCDEF, 0xA5A5A5A5};
  tapi.echo(0, 0, 0, 4, echo3Data);
  readResponse(tapi);

  // Tidy up
  tapi.shutdownAll();
  //  delete tapi;

  return 0;  
}

void readResponse(TApi &tapi) {
  tapi.awaitResponse(0, 0, 0);

  unsigned long length;

  unsigned long *response = tapi.getResponse(0, 0, 0, &length);

  unsigned long outIndex = (unsigned long)(response[1]);
  unsigned long outNumPrims = response[2];
  unsigned long outPrimVersion = response[3];
  cout << "outLength = " << length << ", outIndex = " << outIndex << 
    ", outNumPrims = " << outNumPrims << ", outPrimVersion = " << 
    outPrimVersion <<'\n';
  int outPtr = 4;
  for (unsigned int j=0; j<outNumPrims; j++) {
    unsigned long primLength = response[outPtr++];
    unsigned long primIndex = response[outPtr++];
    unsigned long primId = response[outPtr++];
    unsigned long primVersion = response[outPtr++];
    cout << "primLength = " << primLength << ", primIndex = " << primIndex << 
      ", primId = " << primId << ", primVersion = " << primVersion << '\n';
    cout << "ECHO data: ";
    hex(cout);
    for (unsigned int i=0; i<primLength-4; i++) {
      cout.width(8);
      cout << response[outPtr++] <<" ";
      if (0 == (i+1)%8) cout << endl; 
    };
    if (0 != (primLength-4)%8) cout << endl;
    dec(cout);
  }

  delete [] response;
}
