#include <algorithm>

#include "primListWrapper.h"

#include "RodCrate/RodModule.h"

namespace SctApi {

PrimListWrapper::PrimListWrapper() : list(new SctPixelRod::RodPrimList) {}
PrimListWrapper::PrimListWrapper(unsigned int index) : list(new SctPixelRod::RodPrimList(index)) {}

void PrimListWrapper::clear() 
{
  list->clear();
}

void PrimListWrapper::addPrimitive(const SctPixelRod::RodPrimitive &prim, long *store)
{
  list->push_back(prim);
  if(store)
    data.push_back(store);
}

void PrimListWrapper::addPrimitive(long length, long index, long prim, long rev, const long *primData) 
{
  long *copied = new long[length];

  std::copy(primData, primData+length, copied);

  list->push_back(SctPixelRod::RodPrimitive(length+4, index, prim, rev, copied));
  data.push_back(copied);
}

PrimListWrapper::~PrimListWrapper() 
{
  for(std::list<long *>::const_iterator i = data.begin();
      i != data.end();
      i++) {
    delete [] *i;
  }
}

}
