unsigned short GetWord(FILE* file){

  unsigned char  lo_char, hi_char;
  unsigned short word;

  if(file==NULL){
    printf("bad file\n");
    return 0;
  }

  // Read two bytes
  lo_char = fgetc(file);
  hi_char = fgetc(file);

  if(lo_char == EOF || hi_char == EOF) {
    printf("end of file\n");
    return 0;
  }

  // Swap bytes to form 16 bit word
  word = (hi_char<<8)+lo_char;

  return word;
}

unsigned long GetLWord(FILE* file){

  unsigned char  lo_char, hi_char;
  unsigned char  lo_char2, hi_char2;
  unsigned long word;

  if(file==NULL){
    printf("bad file\n");
    return 0;
  }

  // Read four bytes
  lo_char = fgetc(file);
  hi_char = fgetc(file);
  lo_char2 = fgetc(file);
  hi_char2 = fgetc(file);

  if(lo_char == EOF || hi_char == EOF) {
    printf("end of file\n");
    return 0;
  }

  // Swap bytes to form 16 bit word
  word = (hi_char2<<24)+(lo_char2<<16) + (hi_char<<8)+lo_char;

  return word;
}

void DispHistogram(char* infname, int occ=0) { // , float start, float step, int bursts) {

  // Convert ROD histograms to SCTDAQ format

  char htitle[128];
  char hname[32];

  int i,j;
  unsigned short header[8];
  unsigned short trailer[8];
  unsigned long data[1024*2];
  unsigned short chan,chip;

  TH1F* h_scan_evcnt;
  TH1F* h_scan_errcnt;
  TH2F* h_scan0;
  TH2F* h_scan1;

  TH2F* h_occCount[12];

  FILE* infile;
  //  TFile* outfile;

  infile = fopen(infname,"rb");

  if(infile==NULL) {
    printf("Could not open file %s\n",infname);
    return;
  }  

  int dontSkip = 0;

  short version = GetWord(infile);          // version
  short length = GetWord(infile);
  dontSkip += 1;

  int run = GetLWord(infile);
  int scan = GetLWord(infile);
  dontSkip += 2;

  char moduleName[16];
  for(int i=0; i<16; i++) {
    moduleName[i] = fgetc(infile);
  }
  dontSkip +=4;

  if(version == 1) {
    char startTime[16];
    for(int i=0; i<16; i++) {
      startTime[i] = fgetc(infile);
    }
    dontSkip +=4;
    printf("Started: %s\n", startTime);

    char endTime[16];
    for(int i=0; i<16; i++) {
      endTime[i] = fgetc(infile);
    }
    dontSkip +=4;

    printf("Finished: %s\n", endTime);
  }

  short scanType = GetWord(infile);           // scanType
  short nBins = GetWord(infile);
  dontSkip ++;

  int size = GetLWord(infile);
  dontSkip ++;
  short type = GetWord(infile);
  short width = GetWord(infile);

  if(!(width == 32 || width == 16)) {
    cout << "Bad data width: " << width << endl;
    return;
  } else {
    cout << "Data width: " << width << endl;
  }

  dontSkip ++;

  int bursts = nBins;

  dontSkip +=4;            // Dont skip pointers

  for(int i=0; i<length/4-dontSkip; i++) {
    unsigned long dummy = GetLWord(infile);
  }

  unsigned long pointer = GetLWord(infile);     // Pointer to thresholds
  unsigned long pEvents = GetLWord(infile);
  unsigned long pErrors = GetLWord(infile);
  unsigned long pData = GetLWord(infile);       // Pointer to data

  for(int i=0; i<(pointer-length)/4; i++) {   // Presumably 0
    unsigned long dummy = GetLWord(infile);
  }

  printf("nbins = %d\n", nBins);
  float *threshold = new float[bursts];
  unsigned long *eventCount = new unsigned long[bursts];
  unsigned long *errorCount = new unsigned long[bursts];

  // Scan points
  for(int i=0; i<bursts; i++) {
    unsigned long word = GetLWord(infile);
    threshold[i] = *((float*)(&word));
  }

  // Event counts
  for(int i=0; i<bursts; i++) {
    unsigned long events = GetLWord(infile);
    eventCount[i] = events;
  }

  // Error counts
  for(int i=0; i<bursts; i++) {
    unsigned long errors = GetLWord(infile);
    errorCount[i] = errors;
  }

  double hist_start;
  double hist_stop;

  //  hist_start = start-(step/2);
  //  hist_stop =  start+(112*step)+(step/2);
  float step = threshold[1] - threshold[0];
  if(threshold[0] < threshold[bursts-1]) {
    hist_start = threshold[0]; // start;
    hist_stop =  threshold[bursts-1] + step; // start+(bursts*step);
  } else {
    hist_start =  threshold[bursts-1]; // start+(bursts*step);
    hist_stop = threshold[0] - step; // start;
  }
  printf("start %3.2f stop %3.2f\n",hist_start, hist_stop);

  sprintf(htitle,"ROD Events Requested");
  sprintf(hname,"h_scan_evcnt");
  h_scan_evcnt = new TH1F(hname, htitle, bursts, hist_start, hist_stop);
  h_scan_evcnt->SetFillColor(46);

  sprintf(htitle,"ROD Errors Counted");
  sprintf(hname,"h_scan_errcnt");
  h_scan_errcnt = new TH1F(hname, htitle, bursts, hist_start, hist_stop);
  h_scan_errcnt->SetFillColor(46);

  sprintf(htitle, "%s Stream 0 THRESHOLD Scan", moduleName);
  sprintf(hname,"h_scan0_0");
  h_scan0 = new TH2F(hname,htitle, 768,0.5,768.5, bursts, hist_start, hist_stop);
  h_scan0->SetXTitle("Channel Number");
  h_scan0->SetYTitle("THRESHOLD (mV)");

  sprintf(htitle, "%s Stream 1 THRESHOLD Scan", moduleName);
  sprintf(hname,"h_scan1_0");
  h_scan1 = new TH2F(hname,htitle, 768,0.5,768.5, bursts, hist_start, hist_stop);
  h_scan1->SetXTitle("Channel Number");
  h_scan1->SetYTitle("THRESHOLD (mV)");

  printf("Creating chip occupancy histos\n");

  Double_t xBins[1+128/4 + 1];
  xBins[0] = 0;
  for(int i=0; i<128/4 + 1; i++) {
    xBins[i+1] = i*4+1.0;
  }

  for(int c=0; c<12; c++) {
    sprintf(htitle, "%s Chip %d Occupancy counts", moduleName, c);
    sprintf(hname,"h_occCount_%d", c);
    // char *name,char *title,Int_t nbinsx,const Double_t *xbins ,Int_t nbinsy,Axis_t ylow,Axis_t yup
    h_occCount[c] = new TH2F(hname,htitle, 33, xBins, bursts, hist_start, hist_stop);
    h_occCount[c]->SetXTitle("Channel count");
    h_occCount[c]->SetYTitle("THRESHOLD (mV)");
  }

  printf("Filling event counts...\n");

  for(j=0;j<bursts;j++) {
    h_scan_evcnt->Fill(threshold[j],eventCount[j]);
    h_scan_errcnt->Fill(threshold[j],errorCount[j]);
  }

  int slice = 1;
  int chipNumber;
  Axis_t channelAxis;
  int value;
  if(slice) {
    printf("Building slice histogram...\n");

    for(j=0;j<bursts;j++){
      int words, skip;
      if(type == 16 || type == 6) {
        words = 768*2; skip = 0;
      } else {
        words = 1024*2; skip = 1024-768;
      }
      for(i=0;i<words;i++){
        // data
        if(width == 32) {
          data[i]=GetLWord(infile);
        } else if(width == 16) {
          data[i]=GetWord(infile);
        }

        if(i>0    && i<768)
		  h_scan0->Fill(i,threshold[j],data[i]);

        if(i>(768 + skip) && i<(words-skip))
		  h_scan1->Fill(i-(768 + skip),threshold[j],data[i]);

        if(occ && !(type == 16 || type == 6)) {
          if((i>=768 && i<768 + 32 * 6) || (i>=(768 + 1024) && i<1024 + 768 + 32 * 6)) {
            // Also calculate 0 from sum of others?

            if(i<1024) {
              chipNumber = (i-768)/32;
              channelAxis = (i-768) - 32*chipNumber;
              channelAxis = channelAxis * 4 + 2;
            } else {
              chipNumber = 6+(i-(1024+768))/32;

              channelAxis = (i-(1024+768)) - 32*(chipNumber-6);
              channelAxis = channelAxis * 4 + 2;
            }

            value = data[i];
            h_occCount[chipNumber]->Fill(channelAxis, threshold[j], value);
          }
        }
      }
//      printf("%s\n", (char *)&data[i-8]);
    }
  } else {
    for(i=0;i<512;i++){

      // For each channel we get 100 hex data words:
      //    
      // Event format
      // Header - 8 16 bit words
      // 00 - Chan Chip
      // 04 - 0000 0000
      // 08 - BBBB BBBB
      // 0C - BBBB BBBB
      //
      // Now the real data
      //
      // Trailer - 8 16 bit words
      // F0 - FFFF FFFF 
      // F4 - FFFF FFFF 
      // F8 - FFFF FFFF 
      // FC - FFFF FFFF

      // header
      for(j=0;j<8;j++){
        header[j]=GetWord(infile);
      }

      // data
      for(j=0;j<bursts;j++){
        data[j]=GetWord(infile);
      }

      // trailer
      for(j=0;j<8;j++){
        trailer[j]=GetWord(infile);
      }

      // Fill SCTDAQ scan Histogram
      chan = (header[1]*128)+header[0];

      for(j=0;j<bursts;j++){
        h_scan0->Fill(chan,threshold[j],data[j]);
      }
    
    } 

  }

  fclose(infile);

  // outfile = new TFile("rod.root","RECREATE");

  // h_scan0->Write("h_scan0");
  // h_scan1->Write("h_scan1");
  // h_scan_evcnt->Write("h_scan_evcnt");

  // outfile->Close();

  printf("Draw scan0\n");

  TCanvas *c1 = new TCanvas;
  h_scan_evcnt->Print();
  h_scan0->Print();
  h_scan0->Draw("colz");

  printf("Draw evcnt\n");
  TCanvas *cev = new TCanvas;
  h_scan_evcnt->Draw();

  printf("Draw scan0\n");

  TCanvas *c2 = new TCanvas;
  h_scan1->Print();
  h_scan1->Draw("colz");

  if(occ) {
   TCanvas *c3 = new TCanvas;
   c3->Divide(4, 3);
   for(int c=0; c<12; c++) {
     c3->cd(c+1);
     //    h_occCount[c]->Print();
     //  printf("Draw histo %d\n", c);
     h_occCount[c]->Draw("colz");
   }
  }
}
