#ifndef SCTAPI_LOG_H
#define SCTAPI_LOG_H

#include <fstream>
#include <string>

namespace SctApi {
/**
   A logging class, just an ofstream 
   that opens a fixed file
 */
class Log : public std::ofstream {
 public:
  /// Create file
  Log();
  /// Create file
  Log(std::string fname);
  /// Create file
  Log(std::string fname, int instance);

  /// Make sure file is saved on exit
  ~Log();

 private:
  static std::string getDefaultFileName();
  void printHeader();
  void printTrailer();
};

}
#endif
