#include "../VmeInterface/DummyVmeInterface.h"
#ifndef USE_DUMMY_VME
#include "../VmeInterface/RCCVmeInterface.h"
#endif

#include "rcc_error/rcc_error.h"

#include "VmeDecode.h"

using namespace SctPixelRod;
using namespace std;

namespace SctApi {
  namespace Utility {
    void decodeVme(VmeException &e) {
#ifdef USE_DUMMY_VME
      cout << "Unexpected VmeException in Dummy code!\n";
#else
      cout << "VmeException Code: " << e.getErrorCode() << " Class: ";

      switch(e.getErrorClass()) {
      case VmeException::OK: cout << "OK\n"; break;
      case VmeException::INIT_ERROR: cout << "Init error\n"; break;
      case VmeException::BUS_ERROR: cout << "Bus error\n"; break;
      case VmeException::MAP_ERROR: cout << "Map error\n"; break;
      case VmeException::DMA_ERROR: cout << "Dma error\n"; break;
      default: cout << "Unknown error class\n"; break;
      }

      VmePort *p = e.getPort();

      if(p) {
        cout << "Port: code: " << p->getLastErrcode() << " " 
             << p->getErrorMessage(p->getLastErrcode()) << endl;
      } else {
        int code = e.getErrorCode();
        if(code >= BT_WRITE_ERROR) {
          char err[256];
          rcc_error_string(err, code-BT_WRITE_ERROR);

          cout << " BT_WRITE_ERROR: " << err;
        } else if(code >= BT_READ_ERROR) {
          char err[256];
          rcc_error_string(err, code-BT_READ_ERROR);

          cout << " BT_READ_ERROR: " << err;
        }
      }
#endif
    }
  }
}
