#include <boost/date_time/posix_time/posix_time.hpp>
#include "ScanApi_Test.h"
#include "../SctApiImpl.h"
#include <boost/test/unit_test.hpp>
#include <iostream>

using boost::unit_test_framework::test_suite;
using namespace boost::posix_time;
using namespace boost::gregorian;

namespace SctApi {
  namespace Tests {
    void testDates() {
	ScanDefImpl sdi;
	ptime t(date(2004, 1, 20), time_duration(1,0,0,0));
	sdi.setStartTime(t);

	ptime t2(date(2000, 3, 14), time_duration(1,0,0,0));
	sdi.setEndTime(t2);

	BOOST_CHECK(sdi.getStartTime() == ptime(date(2004, 1, 20), time_duration(1,0,0,0))); 

	BOOST_CHECK(sdi.getEndTime() == ptime(date(2000, 3, 14), time_duration(1,0,0,0)));

        Scan &scan = sdi;

	ptime t3(date(2001, 5, 27), time_duration(1,0,0,0));
	scan.setStartTime(t3);

	ptime t4(date(2006, 2, 13), time_duration(1,0,0,0));
	scan.setEndTime(t4);

        BOOST_CHECK(scan.getStartTime() == ptime(date(2001, 5, 27), time_duration(1,0,0,0)));
	BOOST_CHECK(scan.getEndTime() == ptime(date(2006, 2, 13), time_duration(1,0,0,0)));
    }

    void testTrigs() {
      ScanDefImpl scan;

      scan.setNTrigs(10);
      scan.configure(9, 0.0, 10.0, 1.0);
      BOOST_CHECK(scan.getScanPoints1().size() == scan.getVariableTrigs().size());

      ScanDefImpl scan2;

      scan2.configure(9, 0.0, 15.0, 1.0);
      scan2.setNTrigs(15);
      BOOST_CHECK(scan2.getScanPoints1().size() == scan2.getVariableTrigs().size());
    }

    ScanApi_Test::ScanApi_Test() {
	add(BOOST_TEST_CASE(&testDates));
	add(BOOST_TEST_CASE(&testTrigs));
    }
}
}
