#ifndef SCTAPI_SCTAPIIMPL_H
#define SCTAPI_SCTAPIIMPL_H

#include <boost/shared_ptr.hpp>

// Need complete types for public inheritence
#include "SctApi.h"

namespace SctApi {
/**
   Implement SctApi::Trigger class
*/
class TriggerImpl : public ::SctApi::Trigger {
  TriggerImpl &operator=(const TriggerImpl &);
 public:
  /// Create default L1A trigger
  TriggerImpl();

  TriggerImpl(const TriggerImpl &);

  static boost::shared_ptr<TriggerImpl> clone(const boost::shared_ptr< ::SctApi::Trigger> other);

  /// Call parent's destructor
  virtual ~TriggerImpl();

  void singleL1A();
  void doubleL1A(short unsigned int delay);
  void delayedL1A(short unsigned int delay);
  void calL1A(short unsigned int delay);
  void pulseL1A(short unsigned int delay);
  void softL1A(short unsigned int delay);
  void softCalL1A(short unsigned int delay, short unsigned int delay2);
  void softPulseL1A(short unsigned int delay, short unsigned int delay2);
  void bcL1A(short unsigned int delay);
  void bcCalL1A(short unsigned int delay, short unsigned int delay2);
  void bcPulseL1A(short unsigned int delay, short unsigned int delay2);

  void setCommIncr(unsigned short command, unsigned short incr);
  void getCommIncr(unsigned short &command, unsigned short &incr) const;

  const RODTriggers getRODTriggers() const;

/*   void copy(const ::SctApi::Trigger &trig); */

  void print() const;
private:
//   /// Command values (max 6)
//   TArrayS trigCommand;

//   /// Data values (max 6)
//   TArrayI trigData;

  RODTriggers trigSequence;

  /// Which command value to increment
  int incCmd;

  /// Increment trigger data by (if 0 then don't!)
  int incData;
};

/**
    ScanDefImpl class

    Implement ScanDef class
*/ 
class ScanDefImpl : public ::SctApi::Scan {
  ScanDefImpl &operator=(const ScanDefImpl &);

 public:
  /// Constructor
  ScanDefImpl();

  ScanDefImpl(const ScanDefImpl &);

  static boost::shared_ptr<ScanDefImpl> clone(const boost::shared_ptr< ::SctApi::Scan> other);

  /// Call parent's destructor
  virtual ~ScanDefImpl();

//   /// Print the scan
//   void print() const;

  /// Set up scanPoints
  void configure(UINT16 type, FLOAT32 start, FLOAT32 stop, FLOAT32 step);

  /// Set up scanPoints for set 2
  void configure2(UINT16 type, FLOAT32 start, FLOAT32 stop, FLOAT32 step);

  const boost::shared_ptr< ::SctApi::Trigger> getTrigger1() const;
  const boost::shared_ptr< ::SctApi::Trigger> getTrigger2() const;

  boost::shared_ptr< ::SctApi::Trigger> getTrigger1();
  boost::shared_ptr< ::SctApi::Trigger> getTrigger2();

  void setTrigger1(boost::shared_ptr< ::SctApi::Trigger> trigger);
  void setTrigger2(boost::shared_ptr< ::SctApi::Trigger> trigger);

  void setScanVariable1(unsigned short var);
  void setScanVariable2(unsigned short var);

  unsigned short getScanVariable1() const;
  unsigned short getScanVariable2() const;

  void setNTrigs(unsigned long nTrigs);
  unsigned long getNTrigs() const;

  const TrigPoints getVariableTrigs() const;
  void setVariableTrigs(const TrigPoints &scans);
  void setVariableTrigRange(unsigned short start, unsigned short end, unsigned long value);

  const ScanPoints getScanPoints1() const;
  const ScanPoints getScanPoints2() const;
  void setScanPoints1(const ScanPoints &scans);
  void setScanPoints2(const ScanPoints &scans);

  int getOption(enum ScanOptions) const;
  void setOption(enum ScanOptions, int option);

/*   void copy(const ::SctApi::Scan &scan); */

  void print() const;

  void setScanNumber(unsigned int scan);
  unsigned int getScanNumber() const;
  void setRunNumber(unsigned int scan);
  unsigned int getRunNumber() const;

  std::list<std::string> getModuleList(unsigned int group) const;
  void setModuleList(unsigned int group, std::list<std::string> newList);
  unsigned int getNGroups() const;
  void setNGroups(unsigned int val);
  
  virtual boost::posix_time::ptime getStartTime() const;
  virtual void setStartTime(boost::posix_time::ptime t);
  
  virtual boost::posix_time::ptime getEndTime() const;
  virtual void setEndTime(boost::posix_time::ptime t);  
  
  /// Scan points to use for first module set
  ScanPoints scanPoints;

  /// Scan points for second module set (not used if empty)
  ScanPoints scanPoints2;

  /// Trigger count for each scan point
  TrigPoints trigPoints;

  /// Are all the trigger counts the same?>
  bool allTrigsSame;

private:

  /// Which variable to scan over
  int scanVariable;

  /// Which variable to scan second set over
  int scanVariable2;

  /// Sequence of triggers to send to module set 1
  boost::shared_ptr<Trigger> trigSequence;

  /// Sequence of triggers to send to module set 2
  boost::shared_ptr<Trigger> trigSequence2;

  /// Condensed / expanded
  int full;

  /// 16 / 32
  int bits32;

  /// Loop over the calibration line during the scan
  int loopCalLine;

  /// Which slave distribution to use, see SctApi docs
  int distSlave;

  /// Debug mode (don't kill tasks and don't write data)
  int debug;

  /// Use TIM for triggers
  int tim;

  /// When not in group mode, how often to capture an event for histogramming
  int nth;

  /// Which event of the nth past triggers to capture
  int nth_rem;

  unsigned int scanNumber;
  unsigned int runNumber;

  std::vector<std::list<std::string> > groupLists;
  unsigned int m_maxGroup;
  
  boost::posix_time::ptime startTime;		///< The time the scan started
  boost::posix_time::ptime endTime;			///< The time the scan finished
};
}

#endif
