#ifndef SCTAPI_FWD_DEF_H
#define SCTAPI_FWD_DEF_H

// Declare classes for purposes of CINT interface
namespace SctApi {
class SctApi;
class Trigger;
class Scan; 

class TriggerImpl;
class ScanDefImpl;

class RodInfo;

class ScanControl;

class SctApiException;
class CrateException;

enum BankType {SCTAPI_BANK_PHYSICS, SCTAPI_BANK_SCAN, SCTAPI_BANK_CALIBRATION};
enum ConfigType {SCTAPI_CONFIG_BASIC, SCTAPI_CONFIG_TRIM, SCTAPI_CONFIG_ALL};

struct RodLabel {
  unsigned int partition;
  unsigned int crate;
  unsigned int rod;

  RodLabel(unsigned int partition, unsigned int crate, unsigned int rod) 
    : partition(partition), crate(crate), rod(rod) {}

  RodLabel() : partition(0), crate(0), rod(0) {}

  bool operator==(const RodLabel &) const;
  bool operator<(const RodLabel &) const;
};

 namespace Utility {
  class MemoryBlock;
 }
}

#endif
