#ifndef SCTAPI_DEBUG_H
#define SCTAPI_DEBUG_H

#include <list>
#include <string>
#include <vector>

// In a separate file so we don't change SctApi.h
// But all the cxx files do get updated...

namespace SctApi {
  /**
     Possible options for the Debug class
   */
  enum DebugOptions {DEBUG_DIAG, DEBUG_DIAG2, DEBUG_DUMP_PRIM_BINARY, DEBUG_DIAG_RESPONSE, DEBUG_MODULE_CONFIG,
                     DEBUG_SAVE_PRIM, DEBUG_SAVE_HISTOGRAM, DEBUG_SAVE_RAW_CAPTURE, 
                     DEBUG_VERBOSE_PROBE,
                     DEBUG_PRINT_IN_PRIM, DEBUG_PRINT_OUT_PRIM, 
                     DEBUG_PRINT_CALIB, DEBUG_PRINT_RAW, DEBUG_LOG_PRINT_PRIM, 
                     DEBUG_EXTRA_DUMPS, DEBUG_PRINT_UNKNOWN, DEBUG_BOC_SETUP, DEBUG_DUMP_RAW_EVENT, 
                     DEBUG_SCAN_ERROR_TRAP, DEBUG_SCAN_ERROR_TRAP_ALL, DEBUG_SCAN_AUTO_STALL, DEBUG_SCAN_STEP_MODE, DEBUG_SCAN_PAUSE_PULSE, 
                     DEBUG_SCAN_ROD_MODE_BITS,
                     DEBUG_TIM_SCAN_STATUS,
                     // Marker
                     DEBUG_END_OPTIONS};

  /** Manage debug options, singleton class */
  class Debug {
    /// Which debug options are enabled
    std::list<std::string> debugList;

    /// Possible debug options
    std::vector<std::string> debugOptionList;

    void setupDebugOptions();

    Debug();

    static Debug *instance;
  public:
    /**
       Check option is set, based on string (as enum in lower case without DEBUG and '_')
     */
    bool checkDebugOption(std::string opt);
    /**
       Check option is set, based on DebugOptions enum
     */
    bool checkDebugOption(DebugOptions opt);
    /**
       Set an option
     */
    void setDebugOption(std::string opt);
    /**
       Reset an option
     */
    void unsetDebugOption(std::string opt);
    /**
       Return list of all enabled options
     */
    std::list<std::string> listEnabledDebugOptions();
    /**
       Return list of all possible options
     */
    std::vector<std::string> listDebugOptions();

    /**
       Return singleton instance
     */
    static Debug *getInstance();
  };
}

#endif
