#include <iostream>

// Only for SctApiException...
#include "SctApi.h"
#include "SctApiDebug.h"

using namespace SctApi;

Debug *Debug::instance = 0;

void Debug::setDebugOption(std::string opt) {
  if(find(debugList.begin(), debugList.end(), opt) == debugList.end()) {
    // Check its a valid option
    if(find(debugOptionList.begin(), debugOptionList.end(), opt) != debugOptionList.end()) {
      debugList.push_back(opt);
    } else {
      std::cout << "Option: " << opt << " not known\n";
    }
  }
}

void Debug::unsetDebugOption(std::string opt) {
  if(find(debugList.begin(), debugList.end(), opt) != debugList.end()) {
    debugList.erase(find(debugList.begin(), debugList.end(), opt));
  }
}

std::list<std::string> Debug::listEnabledDebugOptions() {
  return debugList;
}

std::vector<std::string> Debug::listDebugOptions() {
  return debugOptionList;
}

bool Debug::checkDebugOption(std::string opt) {
  if(find(debugList.begin(), debugList.end(), opt) != debugList.end()) {
    return true;
  } else {
    return false;
  }
}

bool Debug::checkDebugOption(DebugOptions intOpt) {
  std::string opt = debugOptionList[intOpt];

  return checkDebugOption(opt);
}

void Debug::setupDebugOptions() {
  debugOptionList.resize(DEBUG_END_OPTIONS);

  for(int i=0; i<DEBUG_END_OPTIONS; i++) {
    std::string name;
    switch(i) {
    case DEBUG_DIAG:
      name = "diag"; 
      break;
    case DEBUG_DIAG2:
      name = "diag2"; 
      break;
    case DEBUG_DUMP_PRIM_BINARY:
      name = "dump_prim_binary"; 
      break;
    case DEBUG_SAVE_PRIM:
      name = "save_prim"; 
      break;
    case DEBUG_VERBOSE_PROBE:
      name = "verbose_probe"; 
      break;
    case DEBUG_PRINT_IN_PRIM:
      name = "print_in_prim"; 
      break;
    case DEBUG_PRINT_OUT_PRIM:
      name = "print_out_prim"; 
      break;
    case DEBUG_DIAG_RESPONSE:
      name = "diag_response"; 
      break;
    case DEBUG_MODULE_CONFIG:
      name = "module_config"; 
      break;
    case DEBUG_PRINT_CALIB:
      name = "print_calib"; 
      break;
    case DEBUG_PRINT_RAW:
      name = "print_raw"; 
      break;
    case DEBUG_LOG_PRINT_PRIM:
      name = "log_print_prim"; 
      break;
    case DEBUG_EXTRA_DUMPS:
      name = "extra_dumps"; 
      break;
    case DEBUG_PRINT_UNKNOWN:
      name = "print_unknown"; 
      break;
    case DEBUG_BOC_SETUP:
      name = "boc_setup"; 
      break;
    case DEBUG_DUMP_RAW_EVENT:
      name = "dump_raw_event"; 
      break;
    case DEBUG_SAVE_HISTOGRAM:
      name = "save_histogram"; 
      break;
    case DEBUG_SAVE_RAW_CAPTURE:
      name = "save_raw_capture"; 
      break; 
    case DEBUG_SCAN_ERROR_TRAP:
      name = "scan_error_trap"; 
      break;
    case DEBUG_SCAN_ERROR_TRAP_ALL:
      name = "scan_error_trap_all"; 
      break;
    case DEBUG_SCAN_AUTO_STALL:
      name = "scan_auto_stall"; 
      break;
    case DEBUG_SCAN_STEP_MODE:
      name = "scan_step_mode"; 
      break;
    case DEBUG_SCAN_PAUSE_PULSE:
      name = "scan_pause_pulse"; 
      break;
    case DEBUG_SCAN_ROD_MODE_BITS:
      name = "scan_rod_mode_bits"; 
      break;
    case DEBUG_TIM_SCAN_STATUS:
      name = "tim_scan_status"; 
      break;
    default:
      std::cout << "Unexpected debug option (" << i << ") source code out of sync with itself\n"; 
      throw SctApiException("************ Failed to setup debug options (**************");
    }

    debugOptionList[i] = name;
  }
}

Debug *Debug::getInstance() {
  if(!instance) {
    instance = new Debug();
  }

  return instance;
}

Debug::Debug() {
  setupDebugOptions();
}

