using namespace std;
#include <vector>
// This needs using std before it!
#include "sctddc/SCTDCSCommand.hxx"

#include "sctConf/configuration.h"

#include "SctApi.h"

#include "utility.h"
using namespace SctApi::Utility;

namespace SctApi {

void SctApi::initDDC() 
{
  // Initialise DDC command
  ddcPartition = new IPCPartition("SCT");
  ddcCtrls[0] = new string("ddc_ct1");
  ddcCtrls[1] = 0;

  ddcCmd = new SCTDCSCommand(*ddcPartition, ddcCtrls);
}

void SctApi::requestHardResetAll() 
{
  cout << "Unimplemented!\n";
}

void SctApi::requestHardReset(UINT32 mid)
{
  unsigned int MUR, module;

  unsigned int partition, crate, rod, channel;
  getpcrc(mid, partition, crate, rod, channel);

  config->translateFromROD(partition, crate, rod, channel,
                           MUR, module);

  unsigned int ppartition, pcrate, pchannel;

  config->translateToPowerSupply(MUR, module, 
                                 ppartition, pcrate, pchannel);

  std::cout << "Should do hard reset on module in " 
            << " partition: " << ppartition 
            << " crate: " << pcrate 
            << " channel: " << pchannel << std::endl;
}

void SctApi::requestIVCurve(UINT32 mid, FLOAT32 start, FLOAT32 stop, FLOAT32 step, UINT16 delay, FLOAT32 currentLim)
{
  log << "requestIVCurve: " << mid << ", " << start << ", " << stop << ", " 
      << step << " " << delay << " " << currentLim << std::endl;

  unsigned int MUR, module;

  unsigned int partition, crate, rod, channel;
  getpcrc(mid, partition, crate, rod, channel);

  config->translateFromROD(partition, crate, rod, channel,
                           MUR, module);

  unsigned int ppartition, pcrate, pchannel;

  config->translateToPowerSupply(MUR, module, 
                                 ppartition, pcrate, pchannel);

  if(!ddcCmd) initDDC();

  log << "ddc->requestIVCurve: " << crate << ", " << channel 
      << ", " << start << ", " << stop << ", " << step 
      << " " << 0 << " " << currentLim << " " << delay << " 10" << std::endl;

#warning "End voltage and current should be changeable"
  float Vend = 0.0;
  float Iwarn = currentLim;

  bool result = ddcCmd->requestIVCurve(crate, channel, start, stop, step, Vend, 
                                       Iwarn, currentLim, delay, 10);

  log << "iv curve success got: " << result << std::endl;
  
}

void SctApi::requestIVCurveAll(FLOAT32 start, FLOAT32 stop, FLOAT32 step, UINT16 delay, FLOAT32 currentLim)
{
}


void SctApi::setSelect(UINT32 mid, bool value)
{
  unsigned int MUR, module;

  unsigned int partition, crate, rod, channel;
  getpcrc(mid, partition, crate, rod, channel);

  config->translateFromROD(partition, crate, rod, channel,
                           MUR, module);

  unsigned int ppartition, pcrate, pchannel;

  config->translateToPowerSupply(MUR, module, 
                                 ppartition, pcrate, pchannel);

  ddcSetChannelParameter(pcrate, pchannel, "LVchCLKS", value?1.0:0.0);
}

void SctApi::setSelectAllInCrate(int crate, bool value, int timeout)
{
  if(!ddcCmd) initDDC();

  ddcCmd->setChannelsSelectLine(crate, value, timeout);
}

void SctApi::changeRunState(int state)
{
  throw SctApiException("changeRunState not implemented!");
}

// void SctApi::ddcGetChannelParameter(int crate, int channel, string dpeName,
//                                     int& dpeValue, int timeout) 
// {
//   log << "ddcGetChannelParameter: " << crate << ", " << channel << ", (" << dpeName << "), " << dpeName.size() << " " << timeout << std::endl;

//   if(!ddcCmd) initDDC();

//   ddcCmd->getChannelParameter(crate, channel, dpeName, dpeValue, timeout);

//   log << "channel parameter got: " << dpeValue << std::endl;
// }

void SctApi::ddcChangeState (int crate, int channel, short state, int timeout) 
{
  if(!ddcCmd) initDDC();

  ddcCmd->changeState(crate, channel, state, timeout);
}

void SctApi::ddcChangeStateAll (int crate, short state, int timeout)
{
  if(!ddcCmd) initDDC();

  ddcCmd->changeState(crate, "all", state, timeout);
}

void SctApi::ddcLoadConfiguration (int crate, short state, int timeout)
{
  if(!ddcCmd) initDDC();

  ddcCmd->loadConfiguration(crate, state, timeout);
}

void SctApi::ddcHardReset (int crate, int channel, int timeout)
{
  if(!ddcCmd) initDDC();

  ddcCmd->hardReset(crate, channel, timeout);
}

void SctApi::ddcHardResetAll (int crate, int timeout)
{
  if(!ddcCmd) initDDC();

  ddcCmd->hardReset(crate, "all", timeout);
}

int SctApi::ddcGetChannelParameterInt (int crate, int channel, string name, int timeout)
{
  log << "ddcGetChannelParameterInt: " << crate << ", " << channel 
      << ", (" << name << "), " << name.size() << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  int dpeValue;
  ddcCmd->getChannelParameter(crate, channel, name, dpeValue, timeout);
  log << "channel parameter got: " << dpeValue << std::endl;

  return dpeValue;
}

float SctApi::ddcGetChannelParameterFloat (int crate, int channel, string name, int timeout)
{
  log << "ddcGetChannelParameterFloat: " << crate << ", " << channel 
      << ", (" << name << "), " << name.size() << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  float dpeValue;
  ddcCmd->getChannelParameter(crate, channel, name, dpeValue, timeout);
  log << "channel parameter got: " << dpeValue << std::endl;

  return dpeValue;
}

string SctApi::ddcGetChannelParameterString (int crate, int channel, string name, int timeout)
{
  log << "ddcGetChannelParameterString: " << crate << ", " << channel 
      << ", (" << name << "), " << name.size() << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  string dpeValue;
  ddcCmd->getChannelParameter(crate, channel, name, dpeValue, timeout);
  log << "channel parameter got: " << dpeValue << std::endl;

  return dpeValue;
}

int SctApi::ddcGetCardParameterInt (int crate, int card, string name, int timeout)
{
  log << "ddcGetCardParameterInt: " << crate << ", " << card 
      << ", (" << name << "), " << name.size() << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  int dpeValue;
  ddcCmd->getCardParameter(crate, card, name, dpeValue, timeout);
  log << "card parameter got: " << dpeValue << std::endl;

  return dpeValue;
}

float SctApi::ddcGetCardParameterFloat (int crate, int card, string name, int timeout)
{
  log << "ddcGetCardParameterFloat: " << crate << ", " << card 
      << ", (" << name << "), " << name.size() << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  float dpeValue;
  ddcCmd->getCardParameter(crate, card, name, dpeValue, timeout);
  log << "card parameter got: " << dpeValue << std::endl;

  return dpeValue;
}

string SctApi::ddcGetCardParameterString (int crate, int card, string name, int timeout)
{
  log << "ddcGetCardParameterString: " << crate << ", " << card 
      << ", (" << name << "), " << name.size() << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  string dpeValue;
  ddcCmd->getCardParameter(crate, card, name, dpeValue, timeout);
  log << "card parameter got: " << dpeValue << std::endl;

  return dpeValue;
}

int SctApi::ddcGetCrateParameterInt (int crate, string name, int timeout)
{
  log << "ddcGetCrateParameterInt: " << crate 
      << ", (" << name << "), " << name.size() << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  int dpeValue;
  ddcCmd->getCrateCtrlParameter(crate, name, dpeValue, timeout);
  log << " crate parameter got: " << dpeValue << std::endl;

  return dpeValue;
}

float SctApi::ddcGetCrateParameterFloat (int crate, string name, int timeout)
{
  log << "ddcGetCrateParameterFloat: " << crate 
      << ", (" << name << "), " << name.size() << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  float dpeValue;
  ddcCmd->getCrateCtrlParameter(crate, name, dpeValue, timeout);
  log << " crate parameter got: " << dpeValue << std::endl;

  return dpeValue;
}

string SctApi::ddcGetCrateParameterString (int crate, string name, int timeout)
{
  log << "ddcGetCrateParameterString: " << crate 
      << ", (" << name << "), " << name.size() << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  string dpeValue;
  ddcCmd->getCrateCtrlParameter(crate, name, dpeValue, timeout);
  log << " crate parameter got: " << dpeValue << std::endl;

  return dpeValue;
}

void SctApi::ddcGetCrateParameters(int crate, std::vector<std::string> names, 
                                   std::map<std::string, float>& nameValues, int timeout)
{
  log << "ddcGetCrateParameters: " << crate << " " << timeout << std::endl;
  if(!ddcCmd) initDDC();

  ddcCmd->getCrateParameters(crate, names, nameValues, timeout);
}

void SctApi::ddcSetChannelParameter (int crate, int channel, std::string name, float value, int timeout)
{
  log << "ddcSetChannelParameter: " << crate << " " << channel
      << ", (" << name << "), " << value << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  ddcCmd->setChannelParameter(crate, channel, name, value, timeout);
}

void SctApi::ddcSetCardParameter (int crate, int card, std::string name, float value, int timeout)
{
  log << "ddcSetCardParameter: " << crate << " " << card
      << ", (" << name << "), " << value << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  ddcCmd->setCardParameter(crate, card, name, value, timeout);
}

void SctApi::ddcSetCrateParameter (int crate, std::string name, float value, int timeout)
{
  log << "ddcSetCrateParameter: " << crate 
      << ", (" << name << "), " << value << " " << timeout << std::endl;

  if(!ddcCmd) initDDC();

  ddcCmd->setCrateCtrlParameter(crate, name, value, timeout);
}

}
