#!/usr/bin/perl -w
use strict;
use Fcntl;

#
# Dave Robinson 16/12/2003
# script to generate look up tables for test data and xml files for sctdaq module tests.
# The script creates two files:
# 1) $lookupfile containing one line for each test:
# serial_number Test_Name Root_path_name_to_Root_files Runno Scanno
#  ... then root file is:
#     Root_path_name_to_Root_files/Runno+/strun{Runno}_Scanno.root
#     where Runno+ implies Runno padded to 6 digits (eg 000582 if Runno is 582)
#
# 2) $xmlfile containing one line for each module:
# serial_number Full_path_name_to_xml_file
#
# Please edit $loopupfile and $xmlfile to choose your target files appropriately.
#

my $archiveDirectory ="/d07/silicon/sctdaq/www/";
my $dataDirectory = "/d07/silicon/sctdaq/data/{host}/000" ;	#{host} will be replaced with the host
my $lookupfile = "ModuleData.cam.txt";
my $xmlfile = "XmlSummaryFile.cam.txt";

my $totalTestCount=0;
my $noDataCount=0;
my $invalidTestCount=0;
my @indexFileList=();
my @noXMLlist=();

&collectResultFiles();

open(OUT,">$lookupfile") || die "Cant open $lookupfile : $!";
open(OUT2,">$xmlfile") || die "Cant open $xmlfile : $!";

my $moduleCount = @indexFileList;
foreach my $indexFile (sort @indexFileList) {
   &extractFileInfo($indexFile);
   }

close(OUT) || die "Cant close $lookupfile : $!";
close(OUT2) || die "Cant close $xmlfile : $!";

print "\n\nCreated tests look up table $lookupfile\n";
print "This contains $totalTestCount tests in total from $moduleCount modules.\n";
print "$invalidTestCount tests were omitted (not compatible with SctRodDaq)\n";
print "$noDataCount modules had XML files, but had no data associated with them\n";

print "\nCreated list of xml files in $xmlfile\n";
my $invalidxmlCount = @noXMLlist; 
if($invalidxmlCount>0) {
   print "But note there were $invalidxmlCount modules without an xml configuration file:\n";
   foreach (@noXMLlist) {
     print "** No xml config file available for $_\n";
     }
}
print "\n";

sub collectResultFiles {

my $indexFileCount=0;
opendir(HDATA,$archiveDirectory) || die("Cant open directory $archiveDirectory: $!");

while(my $serialno = readdir(HDATA)) {

      if($serialno =~/^20220\d{2}02\d{5}$/ && -d "$archiveDirectory$serialno") {
          my $thisDirectory = "$archiveDirectory$serialno"."/Module_Reception";
         
         if(!(-d $thisDirectory)) {next;}

         opendir(RESULTS,$thisDirectory) || die("Cant open $thisDirectory : $!");

         while(my $thisname = readdir(RESULTS)) {
             if($thisname=~/\d{14}_\d{8}_\d+\.txt/) {
                my $thisFile = "$thisDirectory"."/"."$thisname";
                if(-e $thisFile) {push(@indexFileList,$thisFile); $indexFileCount++;}
                }            
             }
          closedir(RESULTS)
         }
}

closedir(HDATA);

}

sub extractFileInfo() {
  my $filename = $_[0];
  my $nextLineIsHost=0;
  my $serialno = "none";
  my $runno="none";
  my $scanno="none";
  my $testtype="not compatible";
  my $basedir = "none";
  my $testcount=0;
  my $flag=0;
  my $trimCount=0;
  open(IN,$filename) || die "Cant open $filename for READ : $!";
  while(<IN>) {
    if(/SERIAL NUMBER\s*:\s*(\d{14})/) {$serialno=$1; $flag |= (1<<1);next;}
    if(/^%(FullBypassTest|PipelineTest|StrobeDelay|ThreePointGain|Trim|ResponseCurve|NO|Timewalk)/) {
       $testtype=$1; 
       $flag |= (1<<0);
       next;
       }
    if($nextLineIsHost == 1) {
        if(/\"(\w+)\"/) {
           my $host=$1;
           $host =~ tr/A-Z/a-z/;
           $basedir=$dataDirectory; 
           $basedir=~s/{host}/$host/;
           $nextLineIsHost=0; $flag |= (1<<2);
           next;
        }
    }
    if(/Run number\s*:\s*(\d+)-(\d+)/) {
        $runno=$1;
        $scanno=$2;
        $flag |= (1<<3);
        next;
        }
    if(/#HOST/) {$nextLineIsHost=1; next;}
    else {$nextLineIsHost=0;}
    if(/%NewTest/) {
        if($testcount>0) {
              if($flag==15) {
                  if($testtype eq "Trim") {
                      $trimCount++;
                  }
                  print OUT "$serialno $testtype $basedir$runno $runno $scanno\n"; $totalTestCount++;
              } else {$invalidTestCount++;}
        }
        $serialno="none";
        $testtype="not compatible";
        $basedir="none";
        $runno="none";
        $scanno="none";
        $flag=0;
        $testcount++;
        }

    #Return if the basedir is not a directory
    if ($flag & 12 == 12 && ! -d "$basedir$runno") {
      print "$basedir$runno is not a directory\n";
      ++$noDataCount;
      return;
    }
  }
  close(IN) || die "Cant close $filename after READ : $!";
  if($flag==15) {
        print OUT "$serialno $testtype $basedir$runno $runno $scanno\n"; 
        if($testtype=~/Timewalk/) {
          my $basedir = &getBaseDir($filename);
          my $thisScanNo = $scanno + 9;
          my $xmlfilename = $basedir."/"."$serialno"."_"."$runno"."_"."$thisScanNo".".xml";
          if(-e $xmlfilename) {print OUT2 "$serialno $xmlfilename\n";}
          else {push(@noXMLlist,$serialno);}
          }
        $totalTestCount++;
       }
  else {$invalidTestCount++;}
  }

sub getBaseDir {
    my ($input,$l,$lasth) ;
    $input=$_[0] ;
    $lasth=-1 ;
    $l=rindex($input,'/') ;
    $lasth=$l if $l>$lasth ;
    if ($lasth>-1) {
	return substr($input,0,$lasth) ;
    }
    return $input ;
}
