#include "XmlSummaryFile.h"
#include "Sct/IoExceptions.h"
#include "Sct/Env.h"
#include <iostream>

using namespace std;

namespace SctTest {

XmlSummaryFile::XmlSummaryFile(string fileName) : file(fileName.c_str()) {
    if (!file.is_open()) throw Sct::FileException(fileName, "Cannot open file", __FILE__, __LINE__);
}

bool XmlSummaryFile::hasMoreRecords() {
    if (file.eof() || !file.is_open()) return false;
    return true;
}

XmlSummaryRecord XmlSummaryFile::getNextRecord() {
    XmlSummaryRecord s;
    if (!hasMoreRecords()) return s;
    file >> s.serialNumber >> s.xmlFile;// >> std::ws;
    s.xmlFile = Sct::Env::substituteVariables(s.xmlFile);
    return s;
}
}
