#ifndef SCTTEST_TESTAPI
#define SCTTEST_TESTAPI

#include "SctApi/SctApi.h"
#include "SctApi/SctApiHisto.h"
#include <memory>
#include <string>
#include <boost/shared_ptr.hpp>
#include "Globals.h"

using std::string;
using std::auto_ptr;

class TH1F;
class TFile;

namespace SctConfiguration {
    class Configuration;
}

namespace SctTest {

class TestApi : public SctApi::SctApi {
public:
    TestApi();
    TestApi(boost::shared_ptr<SctConfiguration::Configuration> newConf);
    virtual ~TestApi() {}

protected:
    //Initialise methods
    virtual int initialiseRod(unsigned int partition, unsigned int crate, unsigned int rod);
    virtual int initialiseTim(unsigned int partition, unsigned int crate);
    virtual int initialiseBOC(unsigned int partition, unsigned int crate, unsigned int rod);
    //virtual int initialiseModule(std::string module);
    
    //Config methods
    virtual void getABCDModule(UINT32 mid, ::SctApi::BankType bank);
    virtual void setABCDModule(UINT32 mid, ::SctApi::BankType bank);
    virtual void sendABCDModule(UINT32 mid, ::SctApi::BankType bank, UINT32 type=2);
    virtual void sendAllABCDModules(::SctApi::BankType bank, UINT32 type = 2);
    
    //Scan methods
    virtual bool preScanHardwareCheck(::SctApi::Scan& scan, ::SctApi::ScanEx& extra);
    virtual int pollHistogramming(::SctApi::ScanEx &ex, int bins, int events, int timeout);
    virtual char* readHistogramRawData(const ::SctApi::Scan& scan, const ::SctApi::ScanEx& extra, UINT32 mid, int frame);
    
private:
    static double calculateScanTime(const ::SctApi::ScanEx& ex);
    void modifyScanInformation(const ::SctApi::Scan& c_scan, const TH1F& triggerData);
};

}

#endif //SCTTEST_TESTAPI
