#ifndef TMODULEDCS_h
#define TMODULEDCS_h

//
// TModuleDCS.h
//
// Version 0.3 PWP 13.12.00
//

#if _MSC_VER >= 1000
#pragma once
#endif

#include "TObject.h"
#include "TDatime.h"
#include "TStopwatch.h"

#define DCS_LOCAL   1
#define DCS_TCP     2

class  TModuleDCS : public TObject {

  public:

    TModuleDCS();
    ~TModuleDCS();

    // Constructor must have no arguments if
    // we are to use this class with ROOT I/O

    void TModuleDCS::SetID(Short_t new_id);

    void TModuleDCS::HVon();
    void TModuleDCS::HVoff();
    void TModuleDCS::LVon();
    void TModuleDCS::LVoff();

    void TModuleDCS::Action();
    void TModuleDCS::Action(Short_t query);

    void TModuleDCS::Query();

    void TModuleDCS::Print();
    void TModuleDCS::Print(Short_t now);

    //
    // Data members
    //

    Short_t id;
    
    Short_t hv_source;  // source of HV data
    Short_t lv_source;  // source of LV data
    Short_t t_source;   // source of temperature data

    //
    // Times of updates and power on Timers
    //

    Int_t date;
    Int_t time;

    Int_t t_HVupdate;
    Int_t t_LVupdate;
    Int_t t_MTupdate;
    Int_t t_ETupdate;

    TStopwatch* HVStopwatch; // time for which HV on
    TStopwatch* LVStopwatch; // time for which LV on
    Double_t HVStopwatchTime;
    Double_t LVStopwatchTime;
    Short_t HVStopwatchRunning;
    Short_t LVStopwatchRunning;

    //
    // Control Information
    //

    Short_t suspended;  // Module suspended due to too many trips

    Short_t HVtrip;     // Trip Status
    Short_t LVtrip;
    Short_t MTtrip;
    Short_t ETtrip;

    Short_t nHVtrips;   // Number of trips encountered
    Short_t nLVtrips;
    Short_t nMTtrips;
    Short_t nETtrips;

    Short_t maxHVtrips; // Maximum number of trips allowed
    Short_t maxLVtrips; // before giving up on this module
    Short_t maxMTtrips; // (-1 means never give up)
    Short_t maxETtrips;

    //
    //
    // Requested State
    // 1. The module itself
    //

    Float_t vdet_set;  // voltage targets
    Float_t vcc_set;
    Float_t vi1_set;
    Float_t vdd_set;
    Float_t vpin_set;
    Float_t vld0_set;
    Float_t vld1_set;

    Short_t select;    // state of SELECT line
    Short_t ramp;      // HV ramp rate

    Float_t idet_lim;  // current limits
    Float_t icc_lim;
    Float_t ivi1_lim;
    Float_t idd_lim;
    Float_t ipin_lim;
    Float_t ild0_lim;
    Float_t ild1_lim;

    //
    // Requested State
    // 2. Environmental limits
    //

    Float_t T1_maximum;
    Float_t T2_maximum;
    Float_t T1_minimum;
    Float_t T2_minimum;

    Float_t ET1_maximum;
    Float_t ET2_maximum;
    Float_t ET1_minimum;
    Float_t ET2_minimum;

    Float_t hum1_maximum;
    Float_t hum2_maximum;
    Float_t hum1_minimum;
    Float_t hum2_minimum;

    // Monitored State
    // 1. The module itself
    //

    Float_t vdet;
    Float_t vcc;
    Float_t vi1;
    Float_t vdd;
    Float_t vpin;
    Float_t vld0;
    Float_t vld1;

    Float_t idet;
    Float_t icc;
    Float_t ivi1;
    Float_t idd;
    Float_t ipin;
    Float_t ild0;
    Float_t ild1;

    Float_t T1;
    Float_t T2;

    Short_t HVstatus;
    Short_t LVstatus;
    Short_t LVtemp;

    //
    // Monitored State
    // 2.  The module environment
    //

    Float_t ET1;  // external temp, eg. Environmental target
    Float_t ET2;  // external temp, eg. Environmental measurement
    Float_t hum1; // Environmental humidity
    Float_t hum2; // Environmental humidity


  private:

    ClassDef(TModuleDCS,1)
};

#endif
