#include "TestApi.h"
#include "Configuration.h"
#include "Sct/Exception.h"

#include "Sct_SctApi/SctApiServer.h"
#include "sctConf/configipc.h"

#include <ipc/object.h>
#include <ipc/server.h>
#include <pmg/pmg_initSync.h>

#include <iostream>
#include <boost/shared_ptr.hpp>

using namespace std;
using namespace boost;
using namespace SctConfiguration;
using namespace SctTest;

auto_ptr<IPCServer> ipcServer;
shared_ptr<SctConfiguration::Configuration> configServer;

void pmgSynch(void *) {
    pmg_initSync();
}

int main(int argc, char** argv) {
    Sct::setExceptionHandlers(argv[0]);

    IPCCore::init(true); // Try reentrant for DDC IS callbacks
    IPCPartition p("SCT");
    ipcServer.reset(new IPCServer(Sct_SctApi_C_SctApi_serverName, p));

    try {
        //For some reason these 2 lines don't work - really strange bug...so use default constructor trick
        //configServer.reset(new ConfigIPC());
        //auto_ptr<TestApi> api(new TestApi(configServer));
        auto_ptr<TestApi> api(new TestApi());

        if (!SctTest::Configuration::instance().publish()) {
            cout << "Failed to publish Configuration" << endl;
            return 2;
        }

//        if (!HighLevelApi::instance().publish()) {
//            cout << "Failed to publish HighLevelApi" << endl;
//            return 3;
//        }

        auto_ptr<SctApiServer> h(new SctApiServer(*api, Sct_SctApi_C_SctApi_instanceName, ipcServer.get()));

        // Try publishing it
        if (!h->publish()) {
            cout << "Failed to publish SctTestApi" << std::endl;
            return 2;
        }

        cout << "Serving...\n";

        ipcServer->doSoon(pmgSynch, NULL);
        ipcServer->run();

        cout << "Run over" << std::endl;
        h->withdraw();
        SctTest::Configuration::instance().withdraw();
//        HighLevelApi::instance().withdraw();

    } catch(SctConfiguration::ConfigurationException &c) {
        std::cout << "ConfigurationException: " << c.what() << std::endl;

        MRSStream mrsStream(p);
        mrsStream << "SctTestApi" << MRS_FATAL << MRS_QUALIF("SctTestApi") << MRS_TEXT("Configuration server not running!") << ENDM;

        exit(1);
    }
}
