#ifndef SCTTEST_SCTDAQROOTFILE_H
#define SCTTEST_SCTDAQROOTFILE_H

#include <memory>
#include <string>
#include <TFile.h>

using std::auto_ptr;
using std::string;

class TH1F;
class TH2D;

namespace SctTest {

/**
This class deal with SCTDAQ root files.
@author Matthew Palmer
*/
class SctDaqRootFile {
public:
    SctDaqRootFile(string fileName);
    char* fillData32(const TH1F& hist0Data, const TH1F& hist1Data);
    char* fillData16(const TH1F& hist0Data, const TH1F& hist1Data);
    auto_ptr<TH2D> fillData(const TH1F& histData);
    void dealWithOccupancy(TH1F& hist0Data, TH1F& hist1Data, TH1F& triggerData, unsigned short scanVar, bool forceConstTrigger=true);
    auto_ptr<TH1F> getTriggerData();
    auto_ptr<TH1F> getHistData(int cycleNum, int id);
    int getCycleNum(string serialNum);

protected:
    TFile file;
};

}

#endif //SCTTEST_SCTDAQROOTFILE_H
