#ifndef SCTTEST_SCANMAP_H
#define SCTTEST_SCANMAP_H

#include <map>
#include <vector>
#include <string>
#include <boost/shared_ptr.hpp>
#include "CommonWithDsp/sctStructure.h"
#include "ScanInfo.h"

using std::multimap;
using std::vector;
using std::string;
using boost::shared_ptr;

namespace SctTest {

class ModuleDataRecord;

/**
  This class represents the map from serial numbers to data files
  */
class ScanMap {
public:
    ///Get the instance of the ScanMap
    static ScanMap& instance();

    /**
     * Initialize the ScanMap with filename. Clears the map first
     * @throws FileException if there is a problem opening the file.
     */
    void initialize(string fileName);

    /**
     * Gets the data file for a given module, configuration and scan variable.
     * @throws NoDataFileException if a data file cannot be found
     */
    string getDataFile(string serialNum, const ABCDModule& config, unsigned short scanVar) const;

    /**
    Converts a serial number into the serial number of the stored data
    */
    static string convertSerial(string serialNum);

private:
    ScanMap() {}
    string getThresholdDataFile(string serialNum, const ABCDModule& config) const;
    string getStrobeDataFile(string serialNum, const ABCDModule& config) const;

    void addFullBypassTest(const ModuleDataRecord& mdr);
    void addPipelineTest(const ModuleDataRecord& mdr);
    void addStrobeDelay(const ModuleDataRecord& mdr);
    void addThreePointGain(const ModuleDataRecord& mdr);
    void addTrim(const ModuleDataRecord& mdr);
    void addResponseCurve(const ModuleDataRecord& mdr);
    void addNoise(const ModuleDataRecord& mdr);
    void addTimewalk(const ModuleDataRecord& mdr);
    string constructFileName(string path, unsigned int runNumber, unsigned int scanNumber) const;

    typedef multimap<ScanInfo, string > DigitalMap;
    DigitalMap digitalMap;
    typedef multimap<string, ThresholdScanDetails> ThresholdMap;
    ThresholdMap thresholdMap;
    typedef multimap<string, StrobeDelayScanDetails> StrobeMap;
    StrobeMap strobeMap;
};
}

#endif //SCTTEST_SCANMAP_H
