#include "ScanInfo.h"
#include "Sct/SctParameters.h"
#include <iostream>

using namespace std;
using namespace Sct;

namespace SctTest {
    
//Return cal charge in fC assuming first chip.
double calcCharge(const ABCDModule& config) {
    return 0.0625 * config.chip[0].caldata.c_factor*config.chip[0].basic.vcal;
}

//Return threshold in fC assuming first chip
double calcThreshold(const ABCDModule& config) {
    const ABCDCaldata &calPtr = config.chip[0].caldata;
    
    double v = 2.5 * config.chip[0].basic.vthr;
    double vv = 0
		;
    switch(calPtr.rc_function){
    case 1: /* polynomial but assume linear*/
	return (v - calPtr.rc_params[0]) / calPtr.rc_params[1];
    case 2: /* grillo */
	vv = calPtr.rc_params[2]/(v-calPtr.rc_params[0]);
        return calPtr.rc_params[2]/(calPtr.rc_params[1] * sqrt(vv*vv-1));
    case 3: /* exp */
        return -calPtr.rc_params[1]* log(calPtr.rc_params[0]/(v-calPtr.rc_params[2])-1);
    case 4: /* linear fit */
        return (v - calPtr.rc_params[0]) / calPtr.rc_params[1];
    default:
        return 0;
    }
}
    
ThresholdScanDetails::ThresholdScanDetails(const ABCDModule& config) {
    //charge
    charge = calcCharge(config);
    
    //range - check they are all the same
    range = config.chip[0].basic.config.trimRange;
    cout << range << "  " << flush;
    for (int i=1; i<nChipModule; ++i) {
	cout << config.chip[i].basic.config.trimRange << " " << flush;
	if (config.chip[i].basic.config.trimRange != range) {
	    range = -1;
	    break;
	}
    }
    cout << endl << range << endl;
    
    //trims - check the first 10
    trims = config.chip[0].trim[0];
    for (int i=1; i<nChipModule; ++i) {
	for (int channel = 0; channel < 10; ++channel) {
	    if (config.chip[i].trim[channel] != trims) trims = -1;
	}
    }
    
    //If trims aren't all the same, set range to -1
    //Fixs problem where are chips are optimally trimed in same range
    if (trims == -1) range = -1;
}

StrobeDelayScanDetails::StrobeDelayScanDetails(const ABCDModule& config) {
    charge = calcCharge(config);
    threshold = calcThreshold(config);
}
}
