#ifndef SCTTEST_MODULEDATA_H
#define SCTTEST_MODULEDATA_H

#include <map>
#include <string>
using std::map;
using std::string;

namespace SctTest {
  
/**
 Test information
*/
struct TestInfo {
    TestInfo();
    string path;		///< Path to the root files
    unsigned int runNumber;	///< Run number
    unsigned int scanNumber;	///< Scan number
};
        
    
/**
  Represents the contents of the ModuleDataFile
  
  @author Matthew Palmer
  */
class ModuleData {
public:
    /**
      Creates an empty ModuleData object
      */
    ModuleData();
    
    /**
      Loads in the data from fileName.  Performs environment variable substitution on fileName
      @throws NoDataFileException if fileName doesn't exist
      @throws DataNotValidException if the format of the file is bad
      */
    ModuleData(string fileName);
    
    /**
      Reloads in the data from fileName.  Performs environment variable substitution on fileName
      @throws NoDataFileException if fileName doesn't exist
      @throws DataNotValidException if the format of the file is bad
      */
    void load(string fileName);
    
    /**
      Get the fileName
      */
    string getFileName() const;
        
    /**
      Returns true if there is data for serialNumber, false otherwise.
      If this method returns true, all the getXXXInfo methods will return without throwing.
      */
    bool dataExists(string serialNumber) const;
    
    ///The following may all throw NoDataException if there is no data for the given serialNumber
    TestInfo getResponseCurveInfo(string serialNumber) const;	///< Get response curve information
    TestInfo get3PtGainInfo(string serialNumber) const;		///< Get 3 pt gain information
    TestInfo getStrobeDelayInfo(string serialNumber) const;	///< Get strobe delay information
    TestInfo getTrimInfo(string serialNumber) const;		///< Get trim information
    TestInfo getPipelineInfo(string serialNumber) const;	///< Get pipepline information
    TestInfo getFullBypassInfo(string serialNumber) const;	///< Get full bypass information
    TestInfo getNoiseOccupancyInfo(string serialNumber) const;	///< Get noise occupancy information
    TestInfo getTimeWalkInfo(string serialNumber) const;	///< Get timewalk information
    
private:
    TestInfo getInfo(string serialNumber, unsigned int index) const;	///< Gets an indexed TestInfo
    string fileName;
    
    struct ModuleDataInfo {
	TestInfo infos[8];
    };
    
    map<string, ModuleDataInfo> dataMap;
};	
	
    
}

#endif //SCTTEST_MODULEDATA_H
