#include "ModuleData.h"
#include "ModuleDataFile.h"
#include "Exceptions.h"
#include "Sct/Env.h"

using namespace Sct;

namespace SctTest {
   
TestInfo::TestInfo() : runNumber(0), scanNumber(0) {}
    
ModuleData::ModuleData() {
    
}

ModuleData::ModuleData(string fileName) {
    load(fileName);
}	
    
void ModuleData::load(string fileName) {
    string temp = Env::substituteVariables(fileName);
    
    dataMap.clear();
    
    ModuleDataFile mdf(temp);
    while (mdf.hasMoreRecords()) {
        ModuleDataRecord mdr = mdf.getNextRecord();
	int index = -1;
	if (mdr.testName == "FullBypassTest") index = 0;
        if (mdr.testName == "PipelineTest") index = 1;
	if (mdr.testName == "StrobeDelay") index = 2;
	if (mdr.testName == "ThreePointGain") index = 3;
	if (mdr.testName == "Trim") index = 4;
	if (mdr.testName == "ResponseCurve") index = 5;
	if (mdr.testName == "NO") index = 6;
	if (mdr.testName == "Timewalk") index = 7;

	if (index >= 0) {
	    dataMap[mdr.serialNumber].infos[index].path = mdr.dataPath;
	    dataMap[mdr.serialNumber].infos[index].runNumber = mdr.runNumber;
	    dataMap[mdr.serialNumber].infos[index].scanNumber = mdr.scanNumber;     
        }
    }
    
    this->fileName = temp;
}

string ModuleData::getFileName() const {
    return fileName;
}
    
bool ModuleData::dataExists(string serialNumber) const {
    if (dataMap.find(serialNumber) == dataMap.end()) return false;
    else return true;
}

TestInfo ModuleData::getInfo(string serialNumber, unsigned int index) const {
    if (dataMap.find(serialNumber) == dataMap.end()) throw NoDataException("No data for " + serialNumber, __FILE__, __LINE__);
    else return dataMap.find(serialNumber)->second.infos[index];    
}

TestInfo ModuleData::getResponseCurveInfo(string serialNumber) const {
    return getInfo(serialNumber, 5);
}

TestInfo ModuleData::getStrobeDelayInfo(string serialNumber) const {
    return getInfo(serialNumber, 2);
}

TestInfo ModuleData::get3PtGainInfo(string serialNumber) const {
    return getInfo(serialNumber, 3);
}

TestInfo ModuleData::getTrimInfo(string serialNumber) const {
    return getInfo(serialNumber, 4);
}

TestInfo ModuleData::getPipelineInfo(string serialNumber) const {
    return getInfo(serialNumber, 1);
}

TestInfo ModuleData::getFullBypassInfo(string serialNumber) const {
    return getInfo(serialNumber, 0);
}

TestInfo ModuleData::getNoiseOccupancyInfo(string serialNumber) const {
    return getInfo(serialNumber, 6);
}

TestInfo ModuleData::getTimeWalkInfo(string serialNumber) const {
    return getInfo(serialNumber, 7);
}
    
}
