#include "HighLevelApi.h"
#include "Configuration.h"
#include "Sct/Exception.h"

#include "sctConf/configipc.h"

#include <ipc/object.h>
#include <ipc/server.h>
#include <pmg/pmg_initSync.h>

#include <iostream>
#include <boost/shared_ptr.hpp>

using namespace std;
using namespace boost;
using namespace SctConfiguration;
using namespace SctTest;

auto_ptr<IPCServer> ipcServer;
shared_ptr<SctConfiguration::Configuration> configServer;

void pmgSynch(void *) {
    pmg_initSync();
}

int main(int argc, char** argv) {
    Sct::setExceptionHandlers(argv[0]);

    IPCCore::init(true); // Try reentrant for DDC IS callbacks
    IPCPartition p("SCT");
    ipcServer.reset(new IPCServer(SctTestApi_C_HighLevelApi_serverName, p));

    try {
        configServer = shared_ptr<SctConfiguration::Configuration>(new SctConfiguration::ConfigIPC());
        if (!HighLevelApi::instance().publish()) {
            cout << "Failed to publish HighLevelApi" << endl;
            return 3;
        }

        cout << "Serving...\n";

        ipcServer->doSoon(pmgSynch, NULL);
        ipcServer->run();

        cout << "Run over" << std::endl;
        HighLevelApi::instance().withdraw();

    } catch(SctConfiguration::ConfigurationException &c) {
        std::cout << "ConfigurationException: " << c.what() << std::endl;

        MRSStream mrsStream(p);
        mrsStream << "SctTestApi" << MRS_FATAL << MRS_QUALIF("SctTestApi") << MRS_TEXT("Configuration server not running!") << ENDM;

        exit(1);
    }
}
