#ifndef SCTTEST_HIGHLEVELAPI_H
#define SCTTEST_HIGHLEVELAPI_H

#include <string>
#include <memory>
#include <ipc/object.h>
#include <boost/shared_ptr.hpp>
#include "ModuleData.h"
#include "SctTestApi.hh"

using std::string;

namespace SctData {
    class ModuleConfiguration;
    class ConfigurationVariable;
}
class TestData;

extern std::auto_ptr<IPCServer> ipcServer;

namespace SctTest {

class HighLevelApi : public IPCObject, public virtual SctTestApi_T_HighLevelApi {
public:
    static HighLevelApi& instance();

    /**
    Sets the serial number and loads in all necessary data.
    @throws NoDataException if it can't find any valid data.
    */
    void setModuleSerial(string serial);
    string getModuleSerial() const;

    /**
     * Sets the data file.
     * @throws Sct::FileException if there is a problem with the file
     */
    void setDataFile(string file);
    string getDataFile() const;

    /**
     * Sets the XML summary file
     * @throws Sct::FileException if there is a problem with the file
     */
    void setXmlSummaryFile(string file);
    string getXmlSummaryFile() const;

    //ILU methods
    virtual void setDataFile (SctTestApiStatus *_status, ilu_T_CString file);
    virtual ilu_T_CString getDataFile (SctTestApiStatus *_status);
    virtual void setXmlSummaryFile (SctTestApiStatus *_status, ilu_T_CString file);
    virtual ilu_T_CString getXmlSummaryFile (SctTestApiStatus *_status);
    virtual void setModuleSerial (SctTestApiStatus *_status, ilu_T_CString serial);
    virtual ilu_T_CString getModuleSerial (SctTestApiStatus *_status);
    virtual void fullBypass(SctTestApiStatus *_status);
    virtual void timeWalk(SctTestApiStatus *_status);
    virtual void strobeDelay(SctTestApiStatus *_status);
    virtual void threePointGain(SctTestApiStatus *_status);
    virtual void responseCurve(SctTestApiStatus *_status);
    virtual void noiseOccupancy(SctTestApiStatus *_status);
    virtual void trim(SctTestApiStatus *_status);
    virtual void pipeline(SctTestApiStatus *_status);

private:
    HighLevelApi();

    /**
    Gets the ModuleConfiguration for the given serial number.
    @throws NoDataException if it can't get any data
    */
    void getConfig(string serial);
    void addAndGetConfig(string serial);
    void publishTest(TestData& t) const;
    string getFileName(const TestInfo& info, unsigned int scanNumber) const;
    void doTest(const TestInfo& info, TestData& data, const SctData::ConfigurationVariable& var) const;
    void publishScan(const TestInfo& info, unsigned int scanNumber, const SctData::ConfigurationVariable& scan_variable, const SctData::ModuleConfiguration& config) const;

    string serial;
    string xmlFile;            ///<The xml summary file
    ModuleData data;
    boost::shared_ptr<SctData::ModuleConfiguration> config;
};
}

#endif //SCTTEST_HIGHLEVELAPI_H
