#ifndef SCTTEST_EXCEPTIONS_H
#define SCTTEST_EXCEPTIONS_H

#include "Sct/Exception.h"

namespace SctTest {

/**
  Generic class for various problems
  @author Matthew Palmer
  @ingroup Exceptions
  */
class SctTestException : public Sct::Exception {
public:
    SctTestException(const string& msg, const string& file, int line) throw() ;    
    SctTestException(Sct::Throwable& cause, const string& file, int line) throw();
    SctTestException(const string& msg, Sct::Throwable& cause, const string& file, int line) throw() ;
    
protected:
    SctTestException() throw() {}        
    
};   

/**
  Used to show there is no appropriate data file for a given scan
  @author Matthew Palmer
  @ingroup Exceptions
  */
class NoDataFileException : public SctTestException {
public:
    NoDataFileException(const string& msg, const string& file, int line) throw() ;    
    NoDataFileException(Sct::Throwable& cause, const string& file, int line) throw();    
    NoDataFileException(const string& msg, Sct::Throwable& cause, const string& file, int line) throw();
    
protected:
    NoDataFileException() throw() {}        
    
};

/**
  There is some problem with the data file
  @author Matthew Palmer
  @ingroup Exceptions
  */
class DataNotValidException : public SctTestException {
public:
    DataNotValidException(const string& msg, const string& file, int line) throw();
    DataNotValidException(Sct::Throwable& cause, const string& file, int line) throw() ;
    DataNotValidException(const string& msg, Sct::Throwable& cause, const string& file, int line) throw() ;

protected:
    DataNotValidException() throw() {}

};

/**
  There is no relevant data
  @author Matthew Palmer
  @ingroup Exceptions
  */
class NoDataException : public SctTestException {
public:
    NoDataException(const string& msg, const string& file, int line) throw();
    NoDataException(Sct::Throwable& cause, const string& file, int line) throw() ;
    NoDataException(const string& msg, Sct::Throwable& cause, const string& file, int line) throw() ;

protected:
    NoDataException() throw() {}

};
}

#endif //SCTTEST_EXCEPTIONS_H
