#ifndef SCTTEST_DUMMYHARDWARE_H
#define SCTTEST_DUMMYHARDWARE_H

#include <map>
#include <vector>
#include "SctApi/SctApi.h"
#include "CommonWithDsp/sctStructure.h"

using std::map;
using std::vector;

namespace SctTest {

/**
  For the moment this class maintains mid=>ABCDModule mappings for 3 banks and the 
  original config.  Currently, the original config is just the first config that is set.
  @author Matthew Palmer
  */
class DummyHardware {
public:
    /**
      Get the intance of the DummyHardware
      */
    static DummyHardware& instance();
    
    /**
      Get the configuration for module mid in bank type.  If there is no such configuration, create it
      */
    const ABCDModule& getConfig(UINT32 mid, SctApi::BankType type);
    
    /**
      Set the configuration for module mid and bank type.  If the module has no previous configuration,
      store it also in the original configuration.
      */
    void setConfig(UINT32 mid, SctApi::BankType type, const ABCDModule& config);
    
    /**
      Get the original configuration, creating it if it doesn't exist (probably wrong!)
      */
    const ABCDModule& getOriginalConfig(UINT32 mid);
    
    /**
      Get the configuration the module is currently configured with.  Create if none.
      */
    const ABCDModule& getCurrentConfig(UINT32 mid);
    
    /**
      Configure a module from a bank.
      */
    void sendConfig(UINT32 mid, SctApi::BankType bank);
    
private:
    DummyHardware();
    vector< map<UINT32, ABCDModule> > configs;		///< Holds the banks of configuration
    map<UINT32, ABCDModule> originalConfig;		///< Holds the original config
    map<UINT32, ABCDModule> currentConfig;		///< Holds the current config
};
}

#endif //SCTTEST_DUMMYHARDWARE_H
