#include "DummyHardware.h"
#include <iostream>

using namespace std;
using namespace SctApi;

namespace SctTest {
    
DummyHardware::DummyHardware() : configs(3) {
}

DummyHardware& DummyHardware::instance() {
    static DummyHardware dh;
    return dh;
}

void printTrims(const ABCDModule& config) {
    cout << "TrimRanges: ";
    for (int i=0; i<12; ++i) 
	cout << config.chip[i].basic.config.trimRange << " ";
    cout << endl;
}

const ABCDModule& DummyHardware::getConfig(UINT32 mid, BankType type) {
    //printTrims(configs[type][mid]);
    return configs[type][mid];
}

void DummyHardware::setConfig(UINT32 mid, BankType type, const ABCDModule& config) {
    //printTrims(config);
    //cout << "DummyHardware::setConfig called.  mid: " << mid << " Bank: " << type << endl;
    if (originalConfig.count(mid) == 0) {
	//cout << "add to original config" << endl;
	originalConfig[mid] = config;
	//cout << " done" << endl;
    }
    //cout << (int)type << endl;
    //cout << configs[type].count(mid) << endl;
    (configs[type])[mid] = config;
    //cout << "Done" << endl;
}

const ABCDModule& DummyHardware::getOriginalConfig(UINT32 mid) {
    return originalConfig[mid];
}
 
const ABCDModule& DummyHardware::getCurrentConfig(UINT32 mid) {    
    //printTrims(currentConfig[mid]);
    return currentConfig[mid];
}
    
void DummyHardware::sendConfig(UINT32 mid, BankType bank) {
    currentConfig[mid] = configs[bank][mid];
    //printTrims(currentConfig[mid]);
}
}
