#ifndef SCTTEST_CONFIGURATION_H
#define SCTTEST_CONFIGURATION_H

#include <string>
#include <ipc/object.h>
#include "SctTestApi.hh"

using std::string;

namespace SctTest {

class Configuration : public IPCObject, public virtual SctTestApi_T_Configuration {
public:
    static Configuration& instance();

    /**
     * Sets the data file.
     * @throws Sct::FileException if there is a problem with the file
     */
    void setDataFile(string file);
    string getDataFile() const;

    void setFastTimes();
    void setRealisticTimes();
    void setScanTime(unsigned int time);
    unsigned int getScanTime() const;
    void setMultiDspEfficiency(double efficiency);
    double getMultiDspEfficiency() const;
    void setReadoutTime(unsigned int time);
    unsigned int getReadoutTime() const;

    //ILU methods:
    virtual void setDataFile (SctTestApiStatus *_status, ilu_T_CString file);
    virtual ilu_T_CString getDataFile (SctTestApiStatus *_status);
    virtual void setFastTimes (SctTestApiStatus *_status);
    virtual void setRealisticTimes (SctTestApiStatus *_status);
    virtual void setScanTime (SctTestApiStatus *_status, ilu_Integer time);
    virtual ilu_Integer getScanTime (SctTestApiStatus *_status);
    virtual void setMultiDspEfficiency (SctTestApiStatus *_status, ilu_Real efficiency);
    virtual ilu_Real getMultiDspEfficiency (SctTestApiStatus *_status);
    virtual void setReadoutTime (SctTestApiStatus *_status, ilu_Integer time);
    virtual ilu_Integer getReadoutTime (SctTestApiStatus *_status);

private:
    Configuration();

    string dataFile;            ///<The data file
    unsigned int scanTime;      ///<The time for a scan of 1 module
    unsigned int readoutTime;   ///<Time to readout 1 module
    double dspEfficiency;       ///<Efficiency of multiple DSPs (max 1.0)
};
}

#endif //SCTTEST_CONFIGURATION_H
