#include "SctData/ErfFitObject.h"
#include "Sct/Exception.h"
#include "SctData/FitFunctions.h"
#include <iostream>
#include <TF1.h>
/**
 * @author Alan Barr 
 * @date 6 December 2002
 * A very simple test of the FitObject Class
 */

using namespace std;
using namespace SctData;

int main(int argc, char** argv) {
  Sct::setExceptionHandlers(argv[0]);
  cout << "FitTest..."<<endl;
  
  auto_ptr<TF1> t ( new TF1("myerf", erf,0.,1.,3) );
  
  t->SetParameter(0,1.0);
  t->SetParameter(1,0.2);
  t->SetParameter(2,0.4);

  t->SetParError(0,0.01);
  t->SetParError(1,0.02);
  t->SetParError(2,0.015);

  t->Print();
  cout<<"NDF="<<t->GetNDF()<<endl;

  auto_ptr<FitObject> g = auto_ptr<FitObject> (new ErfFitObject( *t ));

  cout << "made a FitObject"<<endl;

  g->print();
 
  g->setParName(0,"Norm");
  //g->getStatus()->setDead();
  g->print();
  
  auto_ptr<TF1> h (g->makeRootTF1());

  h->SetName("Alan's function");
  
  h->Print();

}
