#include "mVThresholdVariable.h"
#include <CommonWithDsp/ABCD/ABCDscans.h>

namespace SctData {
    
/* //Create the mVThresholdVariable!
class mVThresholdVariableFactory {
public:
    mVThresholdVariableFactory() {mVThresholdVariable::instance();}
};

mVThresholdVariableFactory factory;
  */  
    
static const mVThresholdVariable& ob = mVThresholdVariable::instance();

//Member functions

mVThresholdVariable::mVThresholdVariable() : ThresholdVariable(ST_VTHR, "Threshold set by mV") {}    
    
const mVThresholdVariable& mVThresholdVariable::instance() throw() {
    static mVThresholdVariable* ob = new mVThresholdVariable();
    return *ob;
}

double mVThresholdVariable::getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw(){
    return getActualPoint(logicalPt);
}

double mVThresholdVariable::getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw(){
    return getActualPoint(logicalPt);
}

double mVThresholdVariable::getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw() {
    return getActualPoint(logicalPt);
}


double mVThresholdVariable::getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw() {
    return getLogicalPoint(actualPt);
}

double mVThresholdVariable::getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw() {
    return getLogicalPoint(actualPt);
}

double mVThresholdVariable::getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw() {
    return getLogicalPoint(actualPt);
}

}
