#ifndef MVCALCHARGEVARIABLE_H
#define MVCALCHARGEVARIABLE_H

#include "CalChargeVariable.h"
#include "Sct/round.h"

using namespace Sct;

namespace SctData {

class mVCalChargeVariable : public CalChargeVariable {
public:
    static const mVCalChargeVariable& instance() throw();
    
    virtual double getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw();
    virtual double getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual double getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw();    
    
    virtual double getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw();
    virtual double getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw();    
    virtual double getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw();   
     
private:
    mVCalChargeVariable();
    ~mVCalChargeVariable() throw() {};
    unsigned char getActualPoint(double logicalPt) const throw();
    double getLogicalPoint(unsigned char actualPt) const throw();
};
    
///To get mV from DAC, multiply by 0.625
inline unsigned char mVCalChargeVariable::getActualPoint(double logicalPt) const throw() {    
    return roundToUChar(logicalPt/0.625);
}

inline double mVCalChargeVariable::getLogicalPoint(unsigned char actualPt) const throw() {
    return 0.625 * actualPt;
}

}

#endif //MVCALCHARGEVARIABLE_H
