#include "mVCalChargeVariable.h"
#include <CommonWithDsp/ABCD/ABCDscans.h>

namespace SctData {  
    
static const mVCalChargeVariable& ob = mVCalChargeVariable::instance();

//Member functions

mVCalChargeVariable::mVCalChargeVariable() : CalChargeVariable(ST_VCAL, "Calibration charge set by mV") {}    
    
const mVCalChargeVariable& mVCalChargeVariable::instance() throw() {
    static mVCalChargeVariable* ob = new mVCalChargeVariable();
    return *ob;
}

double mVCalChargeVariable::getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw(){
    return getActualPoint(logicalPt);
}

double mVCalChargeVariable::getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw(){
    return getActualPoint(logicalPt);
}

double mVCalChargeVariable::getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw() {
    return getActualPoint(logicalPt);
}


double mVCalChargeVariable::getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw() {
    return getLogicalPoint(actualPt);
}

double mVCalChargeVariable::getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw() {
    return getLogicalPoint(actualPt);
}

double mVCalChargeVariable::getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw() {
    return getLogicalPoint(actualPt);
}

}
